/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.placement.placementjob.JobPostingDocumentWinGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.jobpostingdocumentwingrid',
    store: 'placement.placementjob.JobPostingDocumentStore',
    border: true,
    autoScroll: false,
    height: '80%',
    frame: false,
    enableColumnHide: false,
    selType:'checkboxmodel',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },'->',{
		xtype: 'button',
		itemId: 'btnDownloadDispatchForms',
		text:getCommonTranslation('DOWNLOAD_ALL')
	}],
    columns: [{
        header: getCommonTranslation('S_NO'),
        xtype: 'rownumberer',
        align: 'left',
        flex: 1,
        renderer: function(value, metaData, record, rowIndex) {
            return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
        }
    },{
        header: getCommonTranslation('DOCUMENTS'),
        dataIndex: 'documentName',
        flex: 1,
        sortable:false,
        renderer: function(value, rec) {
            var document = rec.record.data.document;
            if (!isNullOrEmpty(document) && document != undefined) {
                return '<a href="#">' + document.name + '</a>';
            } else {
                return value;
            }
        }
    },{
        header: getCommonTranslation('UPLOADED_ON'),
        dataIndex: 'submissionDate',
        flex: 1,
        sortable:false,
        renderer: function(value, rec) {
            var document = rec.record.data.document;
            if (!isNullOrEmpty(document) && document != undefined) {
                return dateRender(document.submissionDate);
            } else {
                return value;
            }
        }
    }]
});