/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.program.CatalogueContentAddEditWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.cataloguecontentaddeditwindow',
	modal: true,
	frame: true,
	title: getCommonTranslation('CATALOGUE_CONTENT'),
	width: 700,
	height: 550,
	autoScroll: true,
	items: [{
		xtype: 'form',
		standardSubmit: false,
		plugins:"formlabelrequired",    
		items:[{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				labelAlign : 'top'
			},
			items : [{
				xtype: 'displayfield',
				name: 'programCodeOrNameField',
				itemId:'programCodeOrNameField',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				width : 460
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'contentTypeField',
				itemId:'contentTypeField',
				fieldLabel: getCommonTranslation('CONTENT_TYPE'),
				emptyText: getCommonTranslation('SELECT_CONTENT_TYPE'),
				store:'common.CatalogueContent',
				valueField:'id',
				displayField:'value',
				allowBlank:false,
				forceSelection:true,
				typeAhead:true
			},{
				xtype : 'radiogroup',
				name: 'fieldTypeField',
				itemId:'fieldTypeField',
				fieldLabel: getCommonTranslation('FIELD_TYPE'),
				defaults: {
					flex: .1
				},
				allowBlank:false,
				items : [{
					boxLabel : getCommonTranslation('HTML'),
					name : 'fieldTypeField',
					inputValue : 'html',
					checked : true
				},{
					boxLabel : getCommonTranslation('TEXT'),
					name : 'fieldTypeField',
					inputValue : 'text'
				}]
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			height: 430,
			defaults : {
				width : '100%',
				//width : 620,
				labelAlign : 'top'
			},
			fieldLabel: getCommonTranslation('CONTENT'),
			labelSeparator: ": <span style='color:red'>*</span>",
			labelAlign : 'top',
			items : [{
	        	xtype: 'ckeditor',
		        itemId: 'contentFieldCK',
		        name:'contentFieldCK',
		        height: 415,
		        maxLength: 5000,
	        },{
	        	xtype:'textarea',
	        	name: 'contentFieldTA',
	        	itemId:'contentFieldTA',
	        	height: 390,
		        maxLength: 5000,
	        	hidden: true,
	        }]
		},{
			xtype: 'fieldcontainer',
			width : '100%',
			layout: 'hbox',
			defaults: {
				width: 190,
				labelAlign: 'top'
			},
			items: [{
	        	xtype:'textfield',
	        	name: 'duration',
	        	fieldLabel: getProgramandcourseTranslation('DURATION'),
	        	itemId:'durationItemId',
	        	maxLength:100,
	    
	        },{
	        	xtype:'customcombobox',
	        	name: 'presentationLanguage',
	        	itemId:'presentationLanguageItemId',
	        	fieldLabel: getProgramandcourseTranslation('PRESENTATION_LANGUAGE'),
	        	store: 'common.MultiLanguageStore',
	        	valueField:'id',
	            displayField:'value',
	           left: 205,
	        },{
	        	xtype:'customcombobox',
	        	name: 'fieldOfStudy',
	        	itemId:'fieldOfStudyItemId',
	        	fieldLabel: getProgramandcourseTranslation('FIELD_OF_STUDY'),
	        	displayField:'value',
                valueField:'id',
                left: 410,
	        }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				//height: 66,
				labelAlign: 'top'
			},
			cls:'programCheckBox',
			items: [{
	        	xtype:'textfield',
	        	name: 'videoURL',
	        	fieldLabel: getProgramandcourseTranslation('VIDEO_URL'),
	        	itemId:'videoURLItemId',
	        	width: 300,
	        	maxLength:100,
	        	style:{
	            	marginTop:'15px !important'
	            }
	        	
	        },{
	        	xtype:'checkbox',
	        	name: 'publishInCatalogue',
	        	boxLabel: getProgramandcourseTranslation('PUBLISH_IN_CATALOGUE'),
	        	itemId:'publishInCatalogueItemId',
	        	inputValue: true,
				uncheckedValue: false,
				/*style:{
	            	marginTop:'20px !important'
	            }*/
	        }]
		 },{
			xtype: 'fieldcontainer',
			width : '100%',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
	        	xtype:'textfield',
	        	name: 'saqaId',
	        	fieldLabel: getCommonTranslation('SAQA_ID'),
	        	itemId:'saqaId',
	        	maxLength:255
	        }]
		 },{
			 xtype: 'fieldcontainer',
			 width : '100%',
			 layout: {
				 type: 'hbox'
			 },
			 defaults: {
				 labelAlign: 'top',
				 width:226
			 },
			 items: [{
					 xtype: 'customcombobox',
					 name: 'editProgramDocumentFileType',
					 itemId: 'editProgramDocumentFileType',
					 fieldLabel: getProgramandcourseTranslation('PC_FILE_TYPE'),
					 store: 'program.ProgramDocumentFileTypeStore',
					 displayField: 'value1',
					 valueField: 'id',
					 forceSelection:true
				 },{
					 xtype: 'button',
					 name: 'programDocument',
					 text:getCommonTranslation('UPLOAD_FILE'),
					 itemId: 'uploadProgramItemId',
					 ui: 'CustomBtnThird',
					 disabled:true,
					 scale : CONSTANTS.BUTTONSIZE,
					 style:{
						 marginTop:'30px'
					 }
				 }]
		 },{
			 xtype: 'fieldcontainer',
			 width : '100%',
			 layout: {
				 type: 'hbox'
			 },
			 defaults: {
				 labelAlign: 'top',
				 width:400
			 },
			 style:{marginLeft: '-10px!important'},
			 items: [{
				 xtype:'programdocumentgrid'
			 }]
		 },{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'btnSubmit',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'btnCancel',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	}]
});
