Ext.define('Academia.view.program.lessonplanning.CreateEditLessonPlanningDetails', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	//formCode:'programForm', 
	//customFieldEntity:CONSTANTS.PROGRAM_CUSTOM_DATA,
	columns: 1,
	alias: 'widget.createeditlessonplanningdetails',
	//title: getCommonTranslation('CREATE_EDIT_BASIC_PROGRAM_DETAILS'),
	itemId:'creatEditLessonPlanDetailItemId',
	autoScroll: true,
	frame: true,
	modal: true,
	method: 'POST',
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	layout: {
		type: 'vbox'
	},
	standardSubmit: false,
	defaults: {
		labelAlign: 'top'
			//width: 226
	},
	plugins:"formlabelrequired",
	items:[
		{
	        xtype: 'hidden',
	        name: 'id',
	        itemId: 'hiddenLessionPlanIdItemId'
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		width: 226,
	    		labelAlign:'top'
	    	},
	    	items: [
	    		{
	    			xtype: 'customcombobox',
	    			name: 'academicTerm',
	    			fieldLabel:getCommonTranslation('ACADEMIC_TERM') ,
	    			itemId:'comboAcademicTerm',
	    			//store:'common.UsersCodeComboStore',
	    			displayField:'value',
	    			valueField:'id',
	    			forceSelection:true,
	    			allowBlank: false,
	    			listeners  :{
						render : function(combo){
							var store=Ext.create('Academia.store.common.AcademicTermStore');
							combo.bindStore(store)
						}
					}
	    		}]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		//width: 226,
	    		labelAlign:'top'
	    	},
	    	items: [
	    		{
	    			xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
					name : 'courseItemId',
					itemId : 'courseItemId',
					store : 'course.AssignedPeriodCoursesFacultyStore',
					displayField : 'courseCodeName',
					valueField : 'courseId',
					queryParam:'name',
					disabled: true,
	    			minChars:3,
	    			width: 460,
	    			allowBlank: false,
	    			typeAhead:false,
	    			enableKeyEvents  : 'true',
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			forceSelection:true,
	    			listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{courseCodeName}'  +
							'</div>';
						}
					}
	    		},{
	    			xtype : 'multiselectcombofield',
	    			fieldLabel : getCommonTranslation('COURSE_VARIANT'),
	    			name : 'courseVariantId',
					itemId : 'courseVariantId',
					store:'course.coursevariants.CourseVariantStore',
					displayField : 'courseVariantCode',
					valueField : 'id',
					disabled: true,
	    			allowBlank: false,
	    			//editable : false,
	    		    forceSelection: true,
	    		    width:226,
	    		    //maxLength:100000,
	    		    matchFieldWidth:false,
	    		    //autoloadStore: false,
	    		    listConfig: {listeners: {
	    				beforeshow: function(picker) {
	    					picker.minWidth = picker.up('combobox').getSize().width;
	    					picker.width = 'auto';
	    					setTimeout(function(){
	    						picker.el.dom.style.width='auto';
	    						picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
	    					},10);
	    				}
	    			},
	    			loadingText: getCommonTranslation('SEARCHING'),
	    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    			getInnerTpl: function() {
	    				return '<div class="search-item">' +
	    				'{code}' +
	    				'</div>';
	    			}}
	    		}]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		//width: 226,
	    		labelAlign:'top'
	    	},
	    	items: [
	    		{
	    			xtype: 'customcombobox',
					name:'facultyId',
					itemId:'facultyId',
					fieldLabel: getCommonTranslation('FACULTY'),
					store:'attendance.AttendanceFacultyList',
					displayField : 'facultyName',
					valueField : 'facultyId',
					queryParam:'name',
	    			minChars:3,
	    			width :226,
	    			allowBlank: false,
	    			typeAhead:false,
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			forceSelection:true,
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{value}' +
	    					'</div>';
	    				}
	    			}
	    		},
	    		{
	            	xtype: 'textfield',
	                name: 'unitTitle',
	                fieldLabel: getCommonTranslation('UNIT_TITLES'),
	                itemId:'unitTitleId',
	                width :460,
	                disabled: true,
	                maxLength: 256,
	                allowBlank: false
	            }]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		width: 226,
	    		labelAlign:'top'
	    	},
	    	items: [	    		
	    		{
	            	xtype: 'textfield',
	                name: 'topics',
	                fieldLabel:getCommonTranslation('TOPICS'),
	                itemId:'topicId',	
	                disabled: true,
	                maxLength: 256,
	                allowBlank: false
	            },
	            {
	            	xtype: 'textfield',
	                name: 'term',
	                fieldLabel: getCommonTranslation('TERM'),
	                itemId:'termId',
	                disabled: true,
	                maxLength: 50,
	                allowBlank: false
	            },
	            {
	            	xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('DURATION'),
					name:'durationId',
					itemId: 'durationId',
					store:'lessonplan.LessonPlanDurationStore',
					displayField: 'value',
					disabled: true,
					valueField: 'id',
					typeAhead:true,					
					forceSelection:true,
					allowBlank: false
	            }]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		//width: 226,
	    		labelAlign:'top'
	    	},
	    	items: [
	    		{
	                xtype: 'textareafield',
	                name: 'aim',
	                width:700,
	                fieldLabel:getCommonTranslation('AIMS'),
	                itemId:'aimId',	 
	                disabled: true,
	                allowBlank: false,
	                maxLength: 10000
	            }]
	    },
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		//width: 226,
	    		labelAlign:'top'
	    	},
	    	items: [{
	            	xtype: 'textareafield',
	                name: 'prerequisite',
	                width:700,
	                fieldLabel:getCommonTranslation('PRE_REQUISITE'),
	                itemId:'prerequisiteId',	                
	                allowBlank: true,
	                disabled: true,
	                maxLength: 10000
	            }]
	    },
	    {
	    	xtype:'panel',
	    	itemId:'objectivePnl',
	    	width:700,
	    	style:{   			   
	    		left:'0px !important',
	    		marginLeft:'0px',
	    	},
	    	items:[{
	    		xtype:'panel',
	    		collapsible : true,
	    		collapsed: false,
	    		style:{
    				marginBottom:'10px',
    				marginLeft:'0px',
    				marginTop:'0px'
    			},
	    		title: 'Objective',//getCommonTranslation('SEARCH'),	    	
	    		items:[{
	    			xtype: 'fieldcontainer',
	    			width:'100%',
	    			layout: {
	    				type: 'hbox'
	    			},
	    			
	    			defaults :{
	    				width: 226,
	    				labelAlign:'top'
	    			},
	    			items: [
	    				{
	    					xtype: 'customcombobox',
	    					fieldLabel:getCommonTranslation('OBJECTIVE') ,
	    					name:'objectiveId',
	    					itemId: 'objectiveId',
	    					store:Ext.create('Academia.store.lessonplan.LessonPlanObjectiveStore'),
	    					displayField:'value',
	    					valueField: 'id',
	    					disabled: true,
	    					forceSelection:true,
	    					allowBlank: false
	    				},
	    				{
	    					xtype      : 'radiogroup',
	    					fieldLabel : getCommonTranslation('IS_SUB_OBJECTIVE'),
	    					name:'isSubObjective',
	    					itemId:'isSubObjectiveID',
	    					disabled: true,
	    					defaults: {
	    						flex: 1
	    					},
	    					layout: 'hbox',
	    					items: [
	    						{
	    							boxLabel  :getCommonTranslation('YES') ,
	    							name      : 'isSubObjective',
	    							inputValue: true
	    						}, {
	    							boxLabel  : getCommonTranslation('NO'),
	    							name      : 'isSubObjective',
	    							inputValue: false,
	    							checked:true
	    						}
	    						]

	    				}]
	    		},
	    		{
	    			xtype: 'fieldcontainer',
	    			width:'100%',
	    			layout: {
	    				type: 'hbox'
	    			},
	    			defaults :{
	    				//width: 226,
	    				labelAlign:'top'
	    			},
	    			items: [
	    				{
	    					xtype: 'textareafield',
	    					name: 'objDesc',
	    					flex:1,
	    					//fieldLabel:getCommonTranslation('PRE-REQUISITE'),
	    					itemId:'objDescription',	                
	    					allowBlank: true,
	    					disabled:true,
	    					maxLength: 10000
	    				}]
	    		},
	    		{
	    			xtype:'panel',
	    			itemId:'subObjectivePnl',
	    			//layout : 'vbox',
	    			width:'100%',
	    			hidden:true,
	    			style:{
	    				marginLeft:'0px',
	    				marginTop:'0px'
	    			},
	    			items:[/*{
	    				xtype : 'fieldcontainer',
	    				defaults : {
	    					labelAlign : 'top',
	    					width:226
	    				},
	    				layout : {
	    					type : 'hbox'
	    				},
	    				items:[{
	    					xtype: 'customcombobox',
	    					name: 'subOjective',
	    					itemId: 'subOjectiveId',
	    					fieldLabel: getProgramandcourseTranslation('Sub Sbjective'),
	    					displayField:'value',
	    					valueField: 'id',
	    					store:'lessonplan.LessonPlanObjectiveStore',
	    					//allowBlank:false,
	    					typeAhead:true,
	    					forceSelection:true
	    				}]
	    			},{
	    				xtype:'fieldcontainer',
	    				width:'100%',
	    				layout:{
	    					type:'hbox'
	    				},
	    				items:[{
	    					xtype: 'textareafield',
	    					name: 'subObjectiveDesc',
	    					//width:'100%',
	    					flex:2,
	    					//fieldLabel:getCommonTranslation('sub_Objective_Desc'),
	    					itemId:'subObjectiveDescId',	                
	    					allowBlank: true,
	    					maxLength: 10000
	    				},{
	    					xtype: 'button',
	    					itemId: 'lessionPlandetailedBtn',
	    					width: 'auto',
	    					cls: 'CustomBodyBtnSettings',
	    					width: 'auto',
	    					text: getCommonTranslation('ADDBUTTONTEXT'),
	    					tooltip: getCommonTranslation('ADD'),
	    					style:{
	    						marginTop:'30px'
	    					},
	    					listeners:{
	    						click:function(obj){
	    							//var form = obj.up('form');
	    							//form.down('#SubmitBtn').setDisabled(true);
	    						}
	    					}
	    				}]
	    			}*/]
	    		}]
	    	}]},
	    {
	    	xtype: 'fieldcontainer',
	    	width:'100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults :{
	    		//width: 226,
	    		labelAlign:'top'
	    	},
	    	items: [
	    		{
	            	xtype: 'datefield',
	                anchor: '100%',
	                fieldLabel: getCommonTranslation('DATE_OF_PLANING'),
	                name: 'dateOfPlanning',
	                itemId:'dateOfPlanningId',
	              //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
	                allowBlank: false,
	    			vtype : 'daterange',
	    			listeners: {
	    				render: function(obj) {
	    					obj = dateFormatRender(obj);						
	    					obj.setValue(new Date());
	    				}
	    			}
	            }]
	    },
	    {
			xtype: 'fieldcontainer',    
			layout : {
				type : 'vbox'
			},
			cls:'horizontal-scrolling-fix',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype:'lessonplanningdocumentgrid',
				itemId:'lessonplanningdocumentgrid',
				style:{
					marginLeft:'0px'
				},
				hidden:true
			}]
		
		},
	    {
	    	xtype:'fieldcontainer',
	    	width:'100%',
	    	layout : {
	    		type : 'hbox'
	    	},

	    	//width:500,
	    	items: [{
	    		xtype: 'button',
	    		text: getCommonTranslation('SAVE'),
	    		itemId: 'lessionPlanSubmitButtonId',
	    		ui: 'CustomBtnSubmit',
	    		scale: CONSTANTS.BUTTONSIZE,
	    		formBind: true
	    	}, {
	    		xtype: 'button',
	    		text: getCommonTranslation('Add Objective'),
	    		itemId: 'lessionPlanSubmitAddAndNewButtonId',
	    		ui: 'CustomBtnSubmit',
	    		disabled:true,
	    		scale: CONSTANTS.BUTTONSIZE
	    	},
	    	{
	    		xtype: 'button',
	    		text: getCommonTranslation('Add Objective'),
	    		itemId: 'lessionPlanSubmitAddAndNewButtonId1',
	    		ui: 'CustomBtnSubmit',
	    		hidden : true,
	    		scale: CONSTANTS.BUTTONSIZE
	    	},{
	    		xtype: 'button',
	    		text: getCommonTranslation('CANCEL'),
	    		itemId: 'btnCancelLessonPlan',
	    		ui: 'CustomBtnCancel',
	    		scale: CONSTANTS.BUTTONSIZE
	    	},
	    	{
				 xtype: 'button',
				 width:460,
				 text:getCommonTranslation('UPLOAD_DOC'),
				 itemId: 'lessionPlanUploadDocs',
				 ui: 'CustomBtnThird',
			   	 scale : CONSTANTS.BUTTONSIZE
			
			}]
	    }
	    ]

});
