/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.program.lessonplanning.LessonPlanningAddExamWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.lessonplanningaddexamwin',
    modal: true,
    frame: true,
    title: getCommonTranslation('ADD_EXAM_DETAILS'),
    width: 700,
    maxHeight: 500,
    autoScroll: true,
    resizable: false,
    closeAction: 'destroy',
    items: [{
        xtype: 'dynamicfieldformwin',
        plugins: "formlabelrequired",
        width: '100%',
        standardSubmit: false,
        title: getCommonTranslation('EVENT_DETAIL'),
        cls: 'eventDetailPnlCls',
        items: [
            {
                xtype: 'panel',
                itemId: 'eventsMainPanel',
                cls: 'eventsMainPanelCls',
                width: '100%',
                style: { padding: 0 },
                bodyStyle: { padding: 0 },
                items: [],
                listeners: {
                    beforeadd: function(panel) {
                        // Save the current scroll position before adding a new item
                       panel.up('window').savedScrollTop = panel.up('window').body.getScroll().top;
                    },
                    add: function(panel) {
                        // Add the new item and update layout
                        panel.up('window').doLayout();
                        
                        // Restore the scroll position after layout is recalculated
                        Ext.defer(function () {
                            panel.up('window').body.setScrollTop(panel.up('window').savedScrollTop);
                        }, 10); // Adjust delay if necessary
                    },
                    beforeremove :function(panel) {
                        // Save the current scroll position before adding a new item
                        panel.up('window').savedScrollTop = panel.up('window').body.getScroll().top;
                     },
                     remove: function(panel) {
                         // Add the new item and update layout
                         panel.up('window').doLayout();
                         
                         // Restore the scroll position after layout is recalculated
                         Ext.defer(function () {
                             panel.up('window').body.setScrollTop(panel.up('window').savedScrollTop);
                         }, 10); // Adjust delay if necessary
                     }
                }
            },
            {
                xtype: 'fieldcontainer',
                items: [{
                    xtype: 'button',
                    text: getCommonTranslation('SAVE'),
                    itemId: 'btnAddExamDetailsSubmit',
                    ui: 'CustomBtnSubmit',
                    scale: CONSTANTS.BUTTONSIZE,
                    formBind: true
                }, {
                    xtype: 'button',
                    text: getCommonTranslation('CANCEL'),
                    itemId: 'btnAddExamDetailsCancel',
                    ui: 'CustomBtnCancel',
                    scale: CONSTANTS.BUTTONSIZE
                }]
            }]
    }]
});