var programPeriodGridStore = Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgramPeriodGridStore');
Ext.define('Academia.view.program.programDetails.programBatchDetails.periods.ProgramPeriodsGrid', {
	//  extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.programperiodsgrid',
	store : 'program.programDetails.programBatches.programPeriod.ProgramPeriodGridStore',
	title : getCommonTranslation('PERIODS_GRID'),
	border: true,
	id:'programPeriodsGridId',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'program.programDetails.programBatches.programPeriod.ProgramPeriodGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),//View department
		iconCls: 'view-icon'
	}, {
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnDefineProgramTerm',
		text: getProgramandcourseTranslation('DEFINE_PROGRAM_TERM')
	}, {
		xtype: 'button',
		itemId: 'btnSetCurrentPeriod',
		text: getProgramandcourseTranslation('SET_CURRENT_PERIOD')
	},{
		xtype: 'button',
		itemId: 'btnPeriodActivityDates',
		text: getProgramandcourseTranslation('PERIOD_ACTIVITY_DATES')
	},{
		xtype: 'button',
		itemId: 'btnServiceRequestSetupDates',
		text: getProgramandcourseTranslation('SERVICE_REQUEST_SETUP_DATES')
	}],
	columns : [ {
		header : getCommonTranslation('PROGRAM_BATCH_PERIOD_NAME'),
//		translationKey: 'PROGRAM_BATCH_PERIOD_NAME',
		dataIndex : 'programPeriodName',
		flex : .2,
		sortable : true
	}, {
		header : getCommonTranslation('PROGRAM_SEQUENCE'),
//		translationKey: 'PROGRAM_BATCH_PERIOD_NAME',
		dataIndex : 'programPeriodSeq',
		flex : .2,
		sortable : true
	},{
		header : getCommonTranslation('ACADEMIC_TERM'),
//		translationKey: 'PROGRAM_BATCH_PERIOD_NAME',
		dataIndex : 'academicTerm',
		flex : .2,
		sortable : true,
		hidden:true,
		renderer: function(academicTerm) {
			if(!isNullOrEmpty(academicTerm)){
				return academicTerm.value;
			}else{
				return " ";
			}
		}
	},{
		header : getCommonTranslation('OPTIONAL_PERIOD'),
//		translationKey: 'PROGRAM_BATCH_PERIOD_NAME',
		dataIndex : 'whetherOptionalPeriod',
		flex : .2,
		sortable : true,
		hidden:true,
		renderer: function(whetherOptionalPeriod) {
			if(whetherOptionalPeriod){
				return "Yes";
			}else{
				return "No";
			}
		}
	}, {
		header : getCommonTranslation('PERIOD_START'),
		dataIndex : 'programPeriodStartDate',
		flex : .2,
		sortable : true,
		renderer: function(date) {
			return date;
		}
	},{
		header :getCommonTranslation('PERIOD_END') ,
		dataIndex : 'programPeriodEndDate',
		flex : .2,
		sortable : true,
		renderer: function(date) {
			return date;
		}
	},{
		header :getCommonTranslation('MINIMUM_COURSES'),
		dataIndex : 'minCourses',
		flex : .2,
		sortable : true
	},{
		header : getCommonTranslation('MAXIMUM_COURSES'),
		dataIndex : 'maxCourses',
		flex : .2,
		sortable : true
	} ,{
		header :getCommonTranslation('MINIMUM_CREDITS'),
		dataIndex : 'minCredits',
		flex : .2,
		hidden:true,
		sortable : true
	},{
		header : getCommonTranslation('MAXIMUM_CREDITS'),
		dataIndex : 'maxCredit',
		flex : .2,
		hidden:true,
		sortable : true
	}, {
		header :getCommonTranslation('SET_DEADLINE_ENROLLMENT') ,
		dataIndex : 'enrollmentLastDate',
		flex : .2,
		sortable : true,
		hidden:true,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header:  getCommonTranslation('REGISTRATION_SETUP_NAME'),
		dataIndex: 'registrationSetupName',
		flex:.2,
		hidden:true,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.registrationTermSetupDetailId)){
				return '<a href=#>'+value+'</a>';
			} else {
				return '-';
			}
		}
	}, {
		header : getCommonTranslation('CURRENT_PERIOD_OF_PROGRAM'),
		dataIndex : 'isCurrentPeriodOfProgram',
		flex : .2,
		hidden:true,
		sortable : true,
		renderer: function(isCurrentPeriodOfProgram) {
			if(isCurrentPeriodOfProgram){
				return "Yes";
			}else{
				return "No";
			}
		}
	},{
		header : getCommonTranslation('PERIOD_YEAR'),
		dataIndex : 'periodYear',
		flex : .2,
		sortable : true,
		renderer: function(periodYear) {
			if(!isNullOrEmpty(periodYear)){
				return periodYear.value;
			}else{
				return " ";
			}
		}
	},{
		header : getCommonTranslation('OFFERED_AT_AL'),
		dataIndex : 'offeredAtALName',
		flex : .2,
		hidden:true,
		sortable : true,
	},{
		header : getCommonTranslation('CAMPUS'),
		dataIndex : 'campus',
		flex : .2,
		hidden:true,
		sortable : true,
	},{
		header : getCommonTranslation('IS_LAST_PERIOD'),
		dataIndex : 'isLastPeriodOfProgram',
		flex : .2,
		sortable : true,
		hidden:true,
		renderer: function(isLastPeriodOfProgram) {
			if(isLastPeriodOfProgram){
				return "Yes";
			}else{
				return "No";
			}
		}
	},{
		header : getCommonTranslation('COMPUTER_USER_AREA'),
		dataIndex : 'computerUserAreaValue',
		flex : .2,
		hidden:true,
		sortable : true
	},{
		header : getCommonTranslation('ATTESTATION_LINE_ONE'),
		dataIndex : 'attestationLineOne',
		flex : .2,
		hidden:true,
		sortable : true
	},{
		header : getCommonTranslation('ATTESTATION_LINE_TWO'),
		dataIndex : 'attestationLineTwo',
		flex : .2,
		hidden:true,
		sortable : true
	},{
		header : getCommonTranslation('PRINT_NAME_IN_FRENCH'),
		dataIndex : 'printNameInFrench',
		flex : .2,
		hidden:true,
		sortable : true
	},{
		header : getCommonTranslation('PRINT_NAME_IN_SPANISH'),
		dataIndex : 'printNameInSpanish',
		flex : .2,
		hidden:true,
		sortable : true
	}
	]
});
