/**
 * @ Dharmendra.Goyal
 */
Ext.define('Academia.view.program.programDetails.programBatchDetails.periods.ServiceRequestSetupDatesList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.servicerequestsetupdateslist',
	store : 'program.programDetails.programBatches.programPeriod.ServiceRequestSetupDatesStore',
	title: getProgramandcourseTranslation('SERVICE_REQUEST_SETUP_DATES'),
	border: true,
	cls: 'periodActivityDateListCls',
	overflowY: 'auto',
	height: 500,
	tbar:[	{
				xtype: 'button',
				itemId: 'applicableForItemId',
				text: getCommonTranslation('APPLICABLE_FOR'),
				disabled: true
			},'->'], 
	
	viewConfig : {
		stripeRows :  CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
	},
	columns: [
		/*{
			xtype: 'rownumberer',
			sortable:false,
			header: getCommonTranslation('S_NO'),
			width: 50
		},*/
		{
			dataIndex: 'requestTypeId',
			sortable:false,
			header: getServiceRequestTranslation('SERVICE_TYPE'),
			flex:1,
			renderer:function(value, meta, record) {
				if(isNullOrEmpty(value)){
					meta.tdCls = 'gridInputCustomStyle'; 
					return getExaminationTranslation('CLICK_TO_ENTER');
				}else{
					return record.data.requestType.value;
				}
			},
			editor: {
				xtype: 'customcombobox',
				name:'requestType',
				itemId:'requestTypeId',
				store:'program.programDetails.programBatches.programPeriod.SetupDatesServiceStore',
				valueField:'id',
				displayField:'value',
				listeners: {
	                change:function(field, newValue, oldValue){
						var selectedVal = field.getDisplayValue();
						var applicableForBtn = field.up('servicerequestsetupdateslist').down('#applicableForItemId');
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						record.get('requestType').id = newValue;
						record.get('requestType').value = field.getDisplayValue();
						
						if(selectedVal == "Program Transfer" || selectedVal == "Student Transfer" || selectedVal == "Exchange Semester"){
							applicableForBtn.setDisabled(false);
						}else{
							applicableForBtn.setDisabled(true);
						}
					}
	            }
			}
		},
		{
		    dataIndex: 'aStartDate',
		    sortable: false,
		    header: getCommonTranslation('ADMIN_START_DATE'),
		    flex: 1,
		    editor: {
		        xtype: 'datefield',
		        name: 'aStartDate',
		        itemId: 'adminStartDateId',
		        listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
					},
					change:function(field, newValue, oldValue){
						var me = this;
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						
						if(newValue){
							record.set('adminStartDate',newValue.getTime());
						}
						else if(oldValue){
							record.set('adminStartDate',oldValue.getTime());
						}
						else{
							record.set('adminStartDate','');
						}
					}
		        }
		    },
		    renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
	        	var dateVal = dateRender(val);
	        	if(dateVal == "NaN-NaN-0NaN"){
	        		return val;	
	        	}else if(!isNullOrEmpty(val)){
	        		var date = moment(new Date(val), "DD/MM/YYYY").format("DD-MM-Y");
	        		if(date == "Invalid date"){
	        			date = moment(new Date(val), "MM/DD/YYYY").format("DD-MM-Y");
	        		}
	        		return date;
	        	}
	        	else{
	        		rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
	        }
		},
		{
		    dataIndex: 'aEndDate',
		    sortable: false,
		    header: getCommonTranslation('ADMIN_END_DATE'),
		    flex: 1,
		    editor: {
		        xtype: 'datefield',
		        name: 'aEndDate',
		        itemId: 'adminEndDateId',
		        listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
					},
					change:function(field, newValue, oldValue){
						var me = this;
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						
						if(newValue){
							record.set('adminEndDate',newValue.getTime());
						}
						else if(oldValue){
							record.set('adminEndDate',oldValue.getTime());
						}
						else{
							record.set('adminEndDate','');
						}
					}
		        }
		    },
		    renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
	        	var dateVal = dateRender(val);
	        	if(dateVal == "NaN-NaN-0NaN"){
	        		return val;	
	        	}else if(!isNullOrEmpty(val)){
	        		var date = moment(new Date(val), "DD/MM/YYYY").format("DD-MM-Y");
	        		if(date == "Invalid date"){
	        			date = moment(new Date(val), "MM/DD/YYYY").format("DD-MM-Y");
	        		}
	        		return date;
	        	}
	        	else{
	        		rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
	        }
		},
		{
		    dataIndex: 'sStartDate',
		    sortable: false,
		    header: getCommonTranslation('STUDENT_START_DATE'),
		    flex: 1,
		    editor: {
		        xtype: 'datefield',
		        name: 'sStartDate',
		        itemId: 'studentStartDateId',
		        listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
					},
					change:function(field, newValue, oldValue){
						var me = this;
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						
						if(newValue){
							record.set('studentStartDate',newValue.getTime());
						}
						else if(oldValue){
							record.set('studentStartDate',oldValue.getTime());
						}
						else{
							record.set('studentStartDate','');
						}
					}
		        }
		    },
		    renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
	        	var dateVal = dateRender(val);
	        	if(dateVal == "NaN-NaN-0NaN"){
	        		return val;	
	        	}else if(!isNullOrEmpty(val)){
	        		var date = moment(new Date(val), "DD/MM/YYYY").format("DD-MM-Y");
	        		if(date == "Invalid date"){
	        			date = moment(new Date(val), "MM/DD/YYYY").format("DD-MM-Y");
	        		}
	        		return date;
	        	}
	        	else{
	        		rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
	        }
		},
		{
		    dataIndex: 'sEndDate',
		    sortable: false,
		    header: getCommonTranslation('STUDENT_END_DATE'),
		    flex: 1,
		    editor: {
		        xtype: 'datefield',
		        name: 'sEndDate',
		        itemId: 'studentEndDateId',
		        listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
					},
					change:function(field, newValue, oldValue){
						var me = this;
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						
						if(newValue){
							record.set('studentEndDate',newValue.getTime());
						}
						else if(oldValue){
							record.set('studentEndDate',oldValue.getTime());
						}
						else{
							record.set('studentEndDate','');
						}
					}
		        }
		    },
		    renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
	        	var dateVal = dateRender(val);
	        	if(dateVal == "NaN-NaN-0NaN"){
	        		return val;	
	        	}else if(!isNullOrEmpty(val)){
	        		var date = moment(new Date(val), "DD/MM/YYYY").format("DD-MM-Y");
	        		if(date == "Invalid date"){
	        			date = moment(new Date(val), "MM/DD/YYYY").format("DD-MM-Y");
	        		}
	        		return date;
	        	}
	        	else{
	        		rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}
	        }
		},
		{
		    dataIndex: 'assigneeId',
		    sortable: false,
		    header: getCommonTranslation('ASSIGNEE')+'<span class="required" style="color:red"> *</span>',
		    flex: 1,
		    editor: {
		    	xtype: 'customcombobox',
		    	name:'assignee',
		    	itemId:'assignee',
		    	store: Ext.create('Academia.store.criteriabuilder.userquicksearch.QuickSearchName',{
		    		autoLoad: true
		    	}),
		    	valueField: 'id',
		    	displayField: 'valueCode',
		    	editable: false,
		    	typeAhead: false,
		    	forceSelection: true,
		    	hideTrigger: false,
		    	listConfig: {
		    		listeners: {
		    			beforeshow: function(picker) {
		    				picker.minWidth = picker.up('combobox').getSize().width;
		    			}
		    		},
		    		loadingText: getCommonTranslation('SEARCHING'),
		    		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    		getInnerTpl: function() {
		    			return '<div class="search-item">' +
		    			'{studentCode} / {studentName}' +
		    			'</div>';
		    		}
		    	},
		    	listeners:{
		    		render:function(combo) {
		    			baseController = Academia.app.getController('Academia.controller.base.BaseController');
		    			var academyLocationId = baseController.getCurrentAcademyLocation();
		    			var store = combo.getStore();
		    			store.on('beforeload', function(){
		    				store.getProxy().extraParams = {
		    					academyLocationIds : academyLocationId
		    				};
		    			});
		    		},
	            	change:function(field, newValue, oldValue){ 
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						record.get('assignee').id = newValue;
					}
		    	}
		    },
		    renderer:function(value, rec, record, rowIndex, colIndex, store, view){
		    	if(!isNullOrEmpty(value) && value !== '') {
					try{
						var index = rec.column.getEditor().store.findExact('id',value);
						if(index !== -1){
							return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.valueCode;
						}else{
							rec.tdCls = 'gridInputCustomStyle';
			                return getExaminationTranslation('CLICK_TO_ENTER');
						}	
					}
					catch(e){
						return null;
					}
				} else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}						
			}
		},
		{
		    dataIndex: 'approverId',
		    sortable: false,
		    header: getCommonTranslation('APPROVER')+'<span class="required" style="color:red"> *</span>',
		    flex: 1,
		    editor: {
		    	xtype: 'customcombobox',
		    	name:'approver',
		    	itemId:'approver',
		    	store: Ext.create('Academia.store.servicerequest.servicerequestsettings.QuickSearchNameApprover',{
		    		autoLoad: true
		    	}),
	            valueField: 'id',
	            displayField: 'valueCode',
	            editable: false,
	            typeAhead: false,
	            forceSelection: true,
	            hideTrigger: false,
	            listConfig: {
	                listeners: {
	                    beforeshow: function(picker) {
	                        picker.minWidth = picker.up('combobox').getSize().width;
	                    }
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{studentCode} / {studentName}' +
	                        '</div>';
	                }
	            },
	            listeners:{
	            	render:function(combo) {
	            		//combo.reset();
	            		baseController = Academia.app.getController('Academia.controller.base.BaseController');
	            		var academyLocationId = baseController.getCurrentAcademyLocation();
	            		var store = combo.getStore();
	            		store.on('beforeload', function(){
					    	store.getProxy().extraParams = {
								academyLocationIds : academyLocationId
							};
	            		});
	            	},
	            	change:function(field, newValue, oldValue){ 
						var grid = field.up('grid');
						var record = grid.getSelectionModel().getSelection()[0];
						record.get('approver').id = newValue;
					}
	            }
		    },
		    renderer:function(value, rec, record, rowIndex, colIndex, store, view){
		    	
		    	var grid = view.ownerCt,
		    		column = grid.columns[0],
		    		editor = column.getEditor(record);
		    	
		    	if(record && record.data.requestTypeId){
		    		var recIdx = editor.getStore().findExact('id', record.data.requestTypeId);
		    		if(recIdx != -1){
		    			var requestRec = editor.getStore().getAt(recIdx);
		    			if(requestRec.data.activeStatus == true){
		    				value = 1;
		    				record.get('approver').id = 1;
		    				record.data.approverId = 1;
		    			} else if(value == 1) {
		    				value = '';
		    				record.get('approver').id = '';
		    				record.data.approverId = '';
		    			}
		    		}
		    	}
		    	
		    	if(value == 1 && value !== ''){
		    		return 'Auto';
		    	}
		    	
	        	if(!isNullOrEmpty(value) && value !== '') {
					try{
						var index = rec.column.getEditor().store.findExact('id',value);
						if(index !== -1){
							return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.valueCode;
						}else{
							rec.tdCls = 'gridInputCustomStyle';
			                return getExaminationTranslation('CLICK_TO_ENTER');
						}	
					}
					catch(e){
						return null;
					}
				} else {
					rec.tdCls = 'gridInputCustomStyle';
	                return getExaminationTranslation('CLICK_TO_ENTER');
				}						
			}
		},
		/*{
			dataIndex: '',
			header: getCommonTranslation('ADD'),
			sortable:false,
			flex:1,
			renderer: function(value, meta, record) {
				return "<div class='addButtonClsForGridActionCls' data-qtip='Add' style='marginRight: 20 auto !important'></div>";
			}
		},*/
		{
			dataIndex: '',
			header: '',//getCommonTranslation('DELETE'),
			sortable:false,
			flex:1,
			renderer: function(value, meta, record) {
				var btns = "<div class='addButtonClsForGridActionCls' data-qtip='Add' style='display: inline-block;float: left;'></div>";
				//if(meta.recordIndex != 0){
					var btns = btns + " <div class='deleteButtonClsForGridActionCls' data-qtip='Delete' style='display: inline-block;float: left;margin-left: 5px !important;'></div>";
				/*}else{
					var btns = btns;
				}*/
				return btns;
			}
		}
	],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(ed, e) {
				var record = e.record;
	            var fieldName = e.field;
	            if (fieldName === 'aStartDate') {
	                var adminEndDate = record.get('aEndDate');
	                var startDateEditor = e.column.getEditor(record);
	                startDateEditor.setMinValue(false);	
	                if (adminEndDate) {
	                    startDateEditor.setMaxValue(Ext.Date.format(adminEndDate, 'Y-m-d'));
	                }else{
	                  startDateEditor.setMaxValue(false);
	                }
	            } else if (fieldName === 'aEndDate') {
	                var adminStartDate = record.get('aStartDate');
	                var endDateEditor = e.column.getEditor(record);
	                endDateEditor.setMaxValue(false); // Clear the previous maxValue
	                if (adminStartDate) {
	                    endDateEditor.setMinValue(Ext.Date.format(adminStartDate, 'Y-m-d'));
	                }else{
	                	endDateEditor.setMinValue(false);
	                }
	            }else if(fieldName === 'sStartDate'){
	                var studentEndDate = record.get('sEndDate');
	                var startDateEditor = e.column.getEditor(record);
	                startDateEditor.setMinValue(false);
	                if (studentEndDate) {
	                    startDateEditor.setMaxValue(Ext.Date.format(studentEndDate, 'Y-m-d'));
	                }else{
	                  startDateEditor.setMaxValue(false);
	                }
	            }else if(fieldName === 'sEndDate'){
	                var studentStartDate = record.get('sStartDate');
	                var endDateEditor = e.column.getEditor(record);
	                endDateEditor.setMaxValue(false);
	                if (studentStartDate) {
	                    endDateEditor.setMinValue(Ext.Date.format(studentStartDate, 'Y-m-d'));
	                }else{
	                	endDateEditor.setMinValue(false);
	                }
	            }else if(fieldName === 'approverId'){
	                if(record.data.approverId == 1 && record.data.approverId != ''){
	                	return false;
	                }
	            }
	        }
        }
	}]
});