/**
 * @author Utsav
 */
Ext.define('Academia.view.program.programDetails.programBatches.BatchCopyWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.batchcopywindow',
	modal: true,
	frame: true,
	title:getProgramandcourseTranslation('BATCH_COPY_TITLE'),
	items: [{		
    xtype: 'idgeneratorform',
    formCode:'batchForm',
    defaults:{
    	labelAlign:'top',
    	width:226
    },
    standardSubmit: false,
    plugins:"formlabelrequired",    
    items:[{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchId',
			fieldLabel: getProgramandcourseTranslation('COPY_FROM_BATCH'),
			store:'program.programbatchdetail.BatchStore',
			valueField:'id',
			displayField:'value',
			allowBlank:false
		},{
			xtype : 'customcombobox',
			name : 'succeedingBatch',
			itemId: 'succeedingBatch',
			fieldLabel : getProgramandcourseTranslation('SUCCEEDING_BATCH'),
			store : 'program.programDetails.programBatches.SucceedingBatches',
			valueField : 'id',
			displayField : 'value',
			editable : false
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype :'textfield',
			name:'name',
			itemId:'batchNameId',
			emptyText: getProgramandcourseTranslation('NEW_BATCH_NAME'),
			fieldLabel: getProgramandcourseTranslation('NEW_BATCH_NAME')
		},{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel : getCommonTranslation('START_DATE'),
			name : 'batchStartDate',
			itemId : 'batchStartDate',
			endDateField : 'batchTillDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange'
		},{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel : getCommonTranslation('END_DATE'),
			name : 'batchTillDate',
			itemId : 'batchTillDate',
			startDateField : 'batchStartDate',
			listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange'
		 }]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype :'textfield',
			name:'firstPeriodName',
			itemId:'firstPeriodName',
			emptyText: getProgramandcourseTranslation('FIRST_PERIOD_NAME'),
			fieldLabel: getProgramandcourseTranslation('FIRST_PERIOD_NAME')
		},{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel : getCommonTranslation('START_DATE'),
			name : 'periodStartDate',
			itemId : 'periodStartDate',
			endDateField : 'periodTillDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange'
		},{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel : getCommonTranslation('END_DATE'),
			name : 'periodTillDate',
			itemId : 'periodTillDate',
			startDateField : 'periodStartDate',
			listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange'
		 }]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel : getCommonTranslation('FIRST_PERIOD_ENROLLMENT_LASTDATE'),
			name : 'enrollmentLastDate',
			itemId : 'enrollmentLastDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.DATE_FORMAT
		 }]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			itemId: 'btnSubmit',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		},{
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			itemId: 'btnCancel',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getProgramandcourseTranslation('BTN_CONTINUE_MANUALLY'),
			formBind:false,
			itemId: 'btnContinue',
			ui: 'CustomBtnThird',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
	}]
});
