/**
 * @author Prashant Choudhary
 */

var courseDetailReportStore = Ext.create('Academia.store.programCourseDashboard.CourseDetailReportStore');
Ext.define('Academia.view.programCourseDashboard.CourseDetailReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.coursedetailreportgrid',
	store: courseDetailReportStore,
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	refreshStoreData:true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : courseDetailReportStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	cls: 'courseDetailReportGridCls',
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	columns: [{
		header:  getCommonTranslation('COURSE_CODE'),
		dataIndex: 'courseCode',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_CODE_TO_BE_PRINTED'),
		dataIndex: 'codeToBePrinted',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_TYPE'),
		dataIndex : 'courseType',
		flex:1,
		sortable : true,
		renderer:function(v){
			if(v){
				return 'Optional';
			}else{
				return 'Mandatory'; 
			}    		
		}
	},{
		header:  getCommonTranslation('NO_OF_COURSE_DEPARTMENTS'),
		dataIndex: 'noOfCourseDepartment',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_ACADEMY_LOCATION_COUNT'),
		dataIndex: 'noOfAcademyLocAssociated',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SECTION_TYPE'),
		dataIndex: 'sectionType',
		flex:1,
		sortable:true,
		renderer:function(v){
			if(v=="CourseSection"){
				return 'Course Section';
			}else if(v=="ProgramBatchSection"){
				return 'Program Batch Section'; 
			}    		
		}
	},{
		header : getCommonTranslation('MARKS_GRADES'),
		dataIndex : 'courseMarksGrades',
		flex :1,
		sortable:true,
		renderer:function(v){
			if(v=="M"){
				return 'Marks';
			}else if(v=="G"){
				return 'Grade'; 
			}    		
		}
	},{
		header : getCommonTranslation('MIN_PASSING_MARK_GRADE'),
		dataIndex : 'minMarksdGrade',
		flex : 1,
		sortable:true
	},{
		header : getCommonTranslation('MAX_PASSING_MARK_GRADE'),
		dataIndex : 'maxMarksGrade',
		flex :1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_CREDITS'),
		dataIndex: 'courseCredits',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('COURSE_COORDINATOR'),
		dataIndex: 'courseCoordinator',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('NO_OF_COURSE_VARIANT_ASSOCIATED'),
		dataIndex: 'noOfCourseVariantsAssociated',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('DOCUMENTS'),
		dataIndex: 'documents',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('NO_OF_REGULAR_COURSE_GROUP_ASSOCIATED'),
		dataIndex: 'noOfRegularCourseGroups',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('NO_OF_COURSE_SPECIALIZATION'),
		dataIndex: 'noOfCourseSpecialization',
		flex:1,
		sortable:true
	}]
});
