/**
 * @author Raghavendra Soni
 */
Ext.define('Academia.view.programCourseDashboard.StudentCourseSectionReportSearchForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.studentcoursesectionreportsearchform',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    defaults: {
        labelAlign: 'top',
        width: '100%'
    },
    plugins: "formlabelrequired",
    items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: '226'
            },
            items: [{
            	xtype: 'customcombobox',
            	fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            	name: 'academicTerm',
            	itemId: 'academicTerm',
            	displayField: 'value',
            	valueField: 'id',
            	typeAhead: true,
            	forceSelection: true,
            	width: 226,
            	hidden: false,
            	allowBlank: false,
            	listeners: {
            		render: function(combo) {
            			var store = Ext
            			.create('Academia.store.common.AcademicTermStore');
            			combo.bindStore(store)
            		}
            	}
            }, {
            	xtype: 'customcombobox',
            	name: 'courseId',
            	itemId: 'courseItemId',
            	store:'course.CourseByAlAndAcademicTermStore',
            	fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
            	valueField: 'id',
            	displayField: 'valueCode',
            	queryParam:'courseName',
            	minChars:3,
            	width:446,
            	typeAhead:false,
            	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
            	enableKeyEvents  : 'true',
            	hideTrigger:false,
            	forceSelection:true,
            	disabled: true,
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	listConfig: {
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code} / {value}' +
            			'</div>';
            		},
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            	}
            }
            ]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: '226'
            },
            items: [{
            	xtype: 'customcombobox',
            	name: 'COURSE_VARIENT_ID',
            	itemId: 'courseVariantId',
            	store:Ext.create('Academia.store.course.coursevariants.ChildCourseVariantByAcademicTermStore'),
            	fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
            	displayField: 'value',
            	valueField: 'id',
            	queryParam:'name',
            	minChars:3,
            	width:680,
            	typeAhead:false,
            	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
            	enableKeyEvents  : 'true',
            	hideTrigger:false,
            	forceSelection:true,
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	allowBlank:true,
            	disabled: true,
            	listConfig: {
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{value}' +
            			'</div>';
            		},
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            	}
            }
            ]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'searchBtn',
                buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind : true
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                itemId: 'resetBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }
    ]
});