/**
 * @author trupti.paoneker
 * 
 * This component is used for to show Currency exchange rate History Details.
 */
Ext.define('Academia.view.receipt.receiptsettings.BankChargesHistoryGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.bankchargeshistorygrid',
    store: 'receipt.receiptsettings.BankChargesHistoryGridStore',
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store: 'receipt.receiptsettings.BankChargesHistoryGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('DATE'),
        dataIndex: 'applicableDate',
        sortable: false,
        flex: 1,
        renderer: function(value) {
        	return dateRender(value);
         }
    },{
        header: getFeeAndPaymentCommonTranslation('FEE_PAYMENT_MODES'),
        dataIndex: 'feePaymentMode',
        sortable: false,
        flex: 1,
        renderer:function(record, value, index){
        	if(!isNullOrEmpty(index.data.feePaymentMode.value)){
        		return index.data.feePaymentMode.value;
        		
        	}
        }
    }, {
        header: getFeeAndPaymentCommonTranslation('BANK_DRAWN_ON_MASTER'),
        dataIndex: 'bankDrawnOnMaster',
        sortable: false,
        flex: 1,
        renderer:function(record, value, index){
        	if(!isNullOrEmpty(index.data.bankDrawnOnMaster.value)){
        		return index.data.bankDrawnOnMaster.value;
        	}
        }
        
    }, {
        header: getFeeAndPaymentCommonTranslation('BANK_CHARGES_APPLICABLE'),
        dataIndex: 'bankChargesApplicable',
        sortable: false,
        flex: 1,
       /* renderer: function(obj) {
            return columnObjRender(obj, 'exchangeRate');
        }*/

    },{
        header: getCommonTranslation('THRESHOLD_LIMIT'),
        dataIndex: 'thresholdLimit',
        flex: 1,
        sortable: true,
        renderer : function(value){
			 if(!isNullOrEmpty(value)){
				 return value;
			 }else{
				 return '-';
			 }
		}
        
    }]
});