/**
 *  @author manisha wagh
 */ 

Ext.define('Academia.view.receipt.receiptsettings.PaymentGrpProgramBatchGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.paymentgrpprogrambatchgrid',
	title : getFeeAndPaymentCommonTranslation('PROGRAM_BATCH'),
	store: 'feeandpayment.finance.FinanceALProgramBatchList',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype:'button',
		itemId: 'nextButton',
		text:getFeeAndPaymentCommonTranslation('NEXT'),
		tooltip: getFeeAndPaymentCommonTranslation('NEXT')
	},{
		xtype: 'button',
		text: getFeeAndPaymentCommonTranslation('SUBMIT'),
		tooltip: getFeeAndPaymentCommonTranslation('SUBMIT'),
		itemId: 'submitProgramBatchMapping',
		hidden:true,
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getFeeAndPaymentCommonTranslation('RESET'),
		tooltip: getFeeAndPaymentCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'programbatchsearchcombo',
		itemId:'programbatchsearchcombo',
		store: 'feeandpayment.finance.FinanceALProgramBatchSearchCombo',
		valueField: 'id',
		displayField: 'batch',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'batchName',
		queryMode: 'remote',
		width:226,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getFeeAndPaymentCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	},{
		header : getFeeAndPaymentCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	}]
});