/**
 * @author Amit G
 */
Ext.define('Academia.view.reports.admission.dashboard.ApplicationCommentsFilter', {   
	extend: 'Ext.form.Panel',
	alias: 'widget.applicationcommentsfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name:'applicantStudentNameSearch',
			itemId:'applicantStudentNameSearch',
			store:'reports.admission.ApplicationByMultipleAcademyStore',
			fieldLabel:getAdmissionTranslation('STUDENT_APPLICATION_ID_CODE_NAME'),
			width:462,
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			hideTrigger:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}

		},{
			xtype : 'customcombobox',
			fieldLabel : getEnquiryTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYearId',
			displayField:'value',
			valueField:'id',
			width:226,
			typeAhead:true,
			forceSelection:true,
			minChars:3,
			store:Ext.create('Academia.store.common.IntakeYearStore'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
	/*		listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}*/
		}]
	},{
		xtype:'fieldcontainer',
		itemId: 'applicationcommentsfilterprogrmbatchseattypecontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'program',
			itemId:'programId',
			 fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store: 'common.ProgramsByAcademyIdLocationId',
			valueField : 'id',
			displayField:'valueCode',
			//editable: false
			valueField:'id',
			forceSelection:true,
			queryParam:'qry',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+
	                    '</div>';
	                }
	            }
		}, {
			xtype: 'customcombobox',
			name: 'batch',
			itemId:'batchId',
			fieldLabel: getPersonModuleTranslation('BATCH'),
			store: 'common.BatchesByProgramId',
			valueField : 'id',
			displayField : 'value',
			disabled:true,
			editable: false
		},{
			xtype : 'multiselectcombofield',
			cls:'commonAutoHeightMultiselectField',
			fieldLabel: getCommonTranslation('SEAT_TYPE'),
			name: 'seatType',
			itemId:'seatTypeId',
			displayField: 'value',
			valueField: 'id',
			typeAhead : true,
			forceSelection : true,
			editable: false,
			disableKeyFilter: false,
			disabled:true,
			store:'enquiry.SeatTypeStore',
			listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
			return '<div class="search-item">' +
						'{code}'  + '{value}' +
				        '</div>';
			}
			}
		}]

	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'datefield',
			name:'fromDate',
			itemId:'fromDate',
			vtype : 'daterange',
			endDateField : 'toDate',
			fieldLabel: getEnquiryTranslation('FROM_DATE'),
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name:'toDate',
			itemId:'toDate',
			vtype : 'daterange',
			startDateField : 'fromDate',
			fieldLabel: getEnquiryTranslation('TO_DATE'),
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]

	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			formBind:true,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});