/**
 * @author <a href="mailto:ankush.solanki@serosoft.in">Ankush Solanki</a>
 *
 */
Ext.define('Academia.view.reports.common.DegreeAuditReportGroupedBarChart', {
    extend: 'Ext.chart.Chart',
    alias: 'widget.degreeauditreportgroupedbarchart',
    animate: true,
    shadow: true,
    initComponent: function() {
        var this$ = this;
        var numberField = !isNullOrEmpty(this.xAxesNumericField)?this.xAxesNumericField:'number';
        var categoryField = !isNullOrEmpty(this.yAxesCategoryField)?this.yAxesCategoryField:'category';
        var numericTitle = !isNullOrEmpty(this.xAxesNumericTitle)?this.xAxesNumericTitle: '';
        var categoryTitle = !isNullOrEmpty(this.yAxesCategoryTitle)?this.yAxesCategoryTitle:'';
        var columnHeight = !isNullOrEmpty(this.columnHeight)?this.columnHeight: REPORT_CONSTANTS.COMMON_COLUMN_HEIGHT;
        var columnColor = !isNullOrEmpty(this.columnColor)?this.columnColor: REPORT_CONSTANTS.COMMON_COLOR;
        var chartStore = null;
        if(!isNullOrEmpty(this.store)){
        	chartStore = Ext.create(this.store);
        }else{
        	chartStore = Ext.create('Ext.data.JsonStore',{
        		fields: ['number', 'category'],
        		data: [{
        			number :0,
        			category : 'Category'
        		}]
        	});
        }
        Ext.apply(this$, {
        	store: chartStore,
            axes: [{
            	type: 'Numeric',
                position: 'bottom',
                fields: [numberField],
                label: {
                    renderer: Ext.util.Format.numberRenderer('0,0')
                },
                title: numericTitle,
                grid: true,
                minimum: 0,
            }, {
                type: 'Category',
                position: 'left',
                fields: [categoryField],
                title: categoryTitle
            }],
            series: [{
                type: 'bar',
                axis: 'bottom',
                highlight: true,
                gutter : 40,
                style: {
                	backgroundColor: '#F0F8FF'
                },
                tips: {
                    trackMouse: true,
                    height: 28,
                    layout: 'fit',
                    renderer: function(storeItem, item) {
                    	var tipTitle = getCommonTranslation(storeItem.get(categoryField)) + ': ' + storeItem.get(numberField);
                    	var length = (tipTitle.length)* 10;
                  	  	this.setWidth(length);
                  	  	this.setTitle(tipTitle);
                    }
                },
                label: {
                	display: 'insideEnd',
                    field: numberField,
                  //  renderer: Ext.util.Format.numberRenderer('0'),
                    orientation: 'horizontal',
                    color: '#333',
                    'text-anchor': 'middle'
                },
                xField: categoryField,
                yField: [numberField],
                renderer: function(sprite, storeItem, barAttr, i, store) {
                	barAttr.fill = columnColor;
                	barAttr.height = columnHeight;
              	  	return barAttr;
                },
                renderer: function(sprite, record, attr, index, store) {
//                	var color = [ "#669900","#3366CC", "#AC3030","#FFAD33", "#FF957A","#FFFF99","#FF9999","#FFFFB2","#99CC99","#D6ADC2","#C2EBFF","#99C2EB"][index];
                	var baseController = Academia.app.getController('Academia.controller.base.BaseController');
                	var color = baseController.getRandomColor(index);
                	var ba = this.chart.axes.get('bottom');
                	if(!isNullOrEmpty(record.data.colorCode)){
               	        color = record.data.colorCode;
               	    }
                	if(!isNullOrEmpty(record.data.remark)){
                    	ba.setTitle(record.data.remark);
               	    }else{
               	    	ba.setTitle("");
               	    }
                	
                    if(store.getCount() <= 5){
                		return Ext.apply(attr, {
                            fill: color,
                        });
                	}
                	else{
	                    return Ext.apply(attr, {
	                        fill: color,
	                    });
                	} 
                }
            }],
            listeners: {
                refresh: function(chart) {
                	var count = chart.getStore().getCount();
                	if(count>0){
                		var gutter = 40;
                		var chartHeight = (count * columnHeight)+ (count * gutter) + 60; 
                		chart.setHeight(chartHeight);
                		chart.doComponentLayout();
                	}
                }
            }
        });

        this$.callParent(arguments);
    }
});