/**
 * This is used for column  and line  chart 
 * @author Abhishek Chouhan
 */
Ext.define('Academia.view.reports.common.ParetoChartReport', {
	extend: 'Ext.chart.Chart',
	alias: 'widget.paretochartreport', 	
	initComponent: function() {
		var this$ = this;
		var numberField = !isNullOrEmpty(this.xAxesNumericField)?this.xAxesNumericField:'number';
        var categoryField = !isNullOrEmpty(this.yAxesCategoryField)?this.yAxesCategoryField:'category';
        var zNumericField = !isNullOrEmpty(this.zAxesNumericField)?this.zAxesNumericField:'number';
        
        var numericTitle = !isNullOrEmpty(this.xAxesNumericTitle)?this.xAxesNumericTitle: getCommonTranslation('NUMERIC_TITLE');
        var categoryTitle = !isNullOrEmpty(this.yAxesCategoryTitle)?this.yAxesCategoryTitle:getCommonTranslation('CATEGOTY_TITLE');
        var columnWidth = !isNullOrEmpty(this.columnWidth)?this.columnWidth: REPORT_CONSTANTS.COMMON_COLUMN_WIDTH;
        var columnColor = !isNullOrEmpty(this.columnColor)?this.columnColor: REPORT_CONSTANTS.COMMON_COLOR;

        var zNumericTitle = !isNullOrEmpty(this.zAxesNumericTitle)?this.zAxesNumericTitle: getCommonTranslation('NUMERIC_TITLE');
        
        var chartStore = null;
        if(!isNullOrEmpty(this.store)){
        	chartStore = Ext.create(this.store);
        }else{
        	chartStore = Ext.create('Ext.data.JsonStore',{
        		fields: ['number', 'category'],
        		data: [{
        			number :0,
        			category : 'Category'
        		}]
        	});
        }
		Ext.apply(this$, {
        	store: chartStore,
        	style: 'background: #fff',
        	animate: true,
        	shadow: true,
        	legend: {
        		position: 'right',
        		boxStrokeWidth: 0,
        		labelFont: '12px Helvetica'
        	},
        	axes: [{
        		type: 'Numeric',
        		position: 'left',
        		fields: numberField,
        		grid: true,
        		minimum: 0,
        		title: numericTitle,
        		label: {
                    renderer: Ext.util.Format.numberRenderer('0,0')
                }
        	}, {
        		type: 'Category',
        		position: 'bottom',
        		fields: categoryField,
        		title: categoryTitle,
        	}, {
        		type: 'Numeric',
        		position: 'right',
        		fields: zNumericField,
        		title: zNumericTitle,
        		minimum: 0,
        		label: {
        			renderer: function(v) {
        				return v.toFixed(2);
        			}
        		}
        	}],
        	series: [{
        		type: 'column',
        		title: 'Count',
        		xField: categoryField,
        		yField: numberField,
        		axis: 'left',
        		showInLegend: true,
        		style: {
        			opacity: 0.80
        		},
        		highlight: {
        			fill: '#000',
        			'stroke-width': 2,
        			stroke: '#fff'
        		},
        		tips: {
        			trackMouse: true,
        			style: 'background: #FFF',
        			height: 20,
        			renderer: function(storeItem, item) {
        			//	this.setTitle(storeItem.get('grade') + ': ' + storeItem.get('studentCount') + ' responses.');
        			  var tipTitle = storeItem.get(categoryField) + ': ' + storeItem.get(numberField);
                   	  var length = (tipTitle.length)* 10;
                   	  this.setWidth(length);
                   	  this.setTitle(tipTitle);
        			}
        		},
        		renderer: function(sprite, record, attr, index, store) {
//                	var color = [ "#669900","#3366CC", "#AC3030","#FFAD33", "#FF957A","#FFFF99","#FF9999","#FFFFB2","#99CC99","#D6ADC2","#C2EBFF","#99C2EB"][index];
                	var baseController = Academia.app.getController('Academia.controller.base.BaseController');
                	var color = '#4286f4'
                    return Ext.apply(attr, {
                        fill: '#4286f4'
                    });
                },
        	}, {
        		type: 'line',
        		axis: 'right',
        		title: 'Distribution Point',
        		xField:categoryField ,
        		yField: zNumericField,
        		gutter : 40,
        		markerConfig: {
                    type: 'circle',
                    size: 4,
                    radius: 4,
                    'stroke-width': 0,
                    fill:'#000000'
                },
        		highlight: true,
        		tips: {
        			trackMouse: true,
        			height: 28,
        			layout: 'fit',
        			renderer: function(storeItem, item) {
        				var totalCount= storeItem.get('gradePoint') * storeItem.get('studentCount');
        				this.setTitle(totalCount);
        			}
        		},
        		showInLegend: true,
        		highlight: {
        			fill: '#000',
        			'stroke-width': 2,
        			stroke: '#000000'
        		},
        		renderer: function(sprite, record, attr, index, store) {
        			var baseController = Academia.app.getController('Academia.controller.base.BaseController');
        			var color = '#000000'
        				return Ext.apply(attr, {
        					fill: color
        				});
        		},
        	}]
		});
		this$.callParent(arguments);
	}
});