/**
 *  This grid is used for unassigned complaint
 *  @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.complaints.UnassignedComplaintGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.unassignedcomplaintgrid',
    title: getServiceRequestTranslation('UNASSIGNED_REQUESTS'),
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        header: getServiceRequestTranslation('GRIEVANCE_ID'),
        dataIndex: 'requestId',
        sortable: true,
        flex: .2,
        renderer: function(value){
        	return '<a href="#">'+ value +'</a>';
        }
    }, {
        header: getServiceRequestTranslation('GRIEVANCE_TYPE'),
        dataIndex: 'requestType',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('GRIEVANCE_DATE'),
        dataIndex: 'requestDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getServiceRequestTranslation('NEXT_FOLLOW_UP_DATE'),
        dataIndex: 'followupPlanDate',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }/*, {
        header: getServiceRequestTranslation('LAST_FOLLOW_UP_DATE'),
        dataIndex: 'endDate',
        sortable: true,
        flex: .2
    }*/, {
        header: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
        dataIndex: 'assignRequest',
        sortable: true,
        flex: .2,
        renderer: function(value){
        	return '<a href="#">'+ getServiceRequestTranslation('ASSIGN_REQUEST') +'</a>';
        }
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.reports.complaints.UnassignedComplaintReportStore');
    }
});