/**
 * This view is used for the Quota Overrides report quick search form.
 * @author rani.naikwade
 */
Ext.define('Academia.view.reports.student.StudentCommunityReportQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentcommunityreportquicksearchform',
    frame: false,
    cls:'customSearchPanel', 
    height: '30%',
    layout: 'vbox',
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'ACADEMIC_TERM_ID',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			hidden : false,
			store : Ext.create('Academia.store.student.report.AcademicTermForCommunityStore')
			/*listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.student.report.AcademicTermForCommunityStore');
					combo.bindStore(store)
				}
			}*/
		},{
			xtype: 'customcombobox',
			name: 'ADMISSION_ID',
			itemId: 'admissionItemId',
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch'),
			fieldLabel:getExaminationTranslation('ADMISSIONID_STUDENTID_STUDENTNAME'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			width: 460,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			maxLength: 100,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		}]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('AGE_GROUP'),		
			name : 'AGE_GROUP',
			itemId : 'ageGroup',
			displayField : 'value',
			valueField : 'code',
			typeAhead : true,
			forceSelection : true,
			hidden : false,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.student.report.AgeGroupForCommunityStore');
					combo.bindStore(store)
				}
			}
		
        },{
            xtype: 'customcombobox',
            name: 'COMMUNITY_ID',
            itemId: 'community',
            fieldLabel:  getCommonTranslation('COMMUNITY'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'remote',
            listeners: {
                render: function(combo) {
                    //var store = Ext.create('Academia.store.othermasters.communitymaster.CommunityComboStore');
                    var store = Ext.create('Academia.store.personinfo.common.services.MappedCommunityByPBSId');
                    combo.bindStore(store);
                }
            }
        },{
			xtype : 'customcombobox',
			name : 'PROGRAM_GROUP_ID',
			itemId : 'Program_Group',
			fieldLabel : getCommonTranslation('PROGRAM_GROUP_NAME'),
			valueField : 'id',
			displayField : 'value',
			forceSelection : true,
            editable: false,
            listeners: {
                render: function(combo) {
                	 var store = Ext.create('Academia.store.personinfo.common.personalinfo.AttendanceReportProgramGroupStore');
                   // var store = Ext.create('Academia.store.admission.applicationFormSale.ProgramGroupComboStore');
                    combo.bindStore(store);
                }
            }
		
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'PROGRAM_ID',
            itemId: 'program',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            valueField: 'id',
            displayField: 'valueCode',
            queryParam:'programName',
            minChars:3,
			allowBlank: true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			 listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
							'{code} / {value}'+ 
						'</div>';
					}
			},
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.student.report.ProgramWithAcademicTermStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'BATCH_ID',
            itemId: 'batch',
            disabled:true,
            fieldLabel: getPersonModuleTranslation('BATCH'),
            editable: false,
            displayField: 'value',
            valueField: 'id',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                    combo.bindStore(store);
                }
            }
        },{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PERIOD'),
			name : 'PERIOD_ID',
			itemId : 'periodId',
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			disabled:true,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
					combo.bindStore(store)
				}
			}
		
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '100%',
        defaults: {
            labelAlign: 'top',
        },
        items: [{
            xtype: 'customcombobox',
            name: 'SECTION_ID',
            itemId: 'section',
            fieldLabel: getPersonModuleTranslation('SECTION'),
            editable: false,
            width: 226,
            valueField: 'id',
            disabled:true,
            displayField: 'value',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionMultiSelect');
                    combo.bindStore(store);
                }
            }
        },{
        	xtype: 'checkboxfield',
        	labelAlign: 'right',
        	style:{
        		marginLeft:'8px',
        		marginTop:'25px'
        	},
        	itemId:'studentsWithOutCommunity',
        	boxLabel: getCommonTranslation('STUDENTS_WITHOUT_COMMUNITY'),
        	name: 'STUDENTS_WITHOUT_COMMUNITY',
        	inputValue : true
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '100%',
        defaults: {
            labelAlign: 'top',
        },
        items: [{
        	xtype: 'radiogroup',
			itemId: 'optInOptOutRadioItemId',
			name: 'optInOptOutRadio',
			width: 460,
			hidden: false,
			items: [{
				boxLabel: getCommonTranslation('OPT_IN'),
				name: 'optInOptOut',
				itemId : 'optInItemId',
				inputValue: 'OPT_IN',
				checked: true
			}, {
				boxLabel: getCommonTranslation('OPT_OUT'),
				name: 'optInOptOut',
				itemId : 'optOutItemId',
				inputValue: 'OPT_OUT'

			}]
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '100%',
        defaults: {
            labelAlign: 'top',
        },
        items: [{
        	xtype: 'datefield',
			name: 'DATE_OF_JOINING_FROM',
			itemId: 'DATE_OF_JOINING_FROM',
			vtype: 'daterange',
			endDateField: 'DATE_OF_JOINING_TO',
			width: 226,
			fieldLabel: getCommonTranslation('DATE_OF_JOINING_FROM'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        },{
        	xtype: 'datefield',
			name: 'DATE_OF_JOINING_TO',
			itemId: 'DATE_OF_JOINING_TO',
			vtype: 'daterange',
			startDateField: 'DATE_OF_JOINING_FROM',
			width: 226,
			fieldLabel: getCommonTranslation('DATE_OF_JOINING_TO'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        width: '100%',
        defaults: {
            labelAlign: 'top',
        },
        items: [{
        	xtype: 'datefield',
			name: 'EXIT_DATE_FROM',
			itemId: 'EXIT_DATE_FROM',
			vtype: 'daterange',
			endDateField: 'EXIT_DATE_TO',
			width: 226,
			fieldLabel: getCommonTranslation('EXIT_DATE_FROM'),
			hidden: true,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        },{
        	xtype: 'datefield',
			name: 'EXIT_DATE_TO',
			itemId: 'EXIT_DATE_TO',
			vtype: 'daterange',
			startDateField: 'EXIT_DATE_FROM',
			width: 226,
			fieldLabel: getCommonTranslation('EXIT_DATE_TO'),
			hidden: true,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        style :{
        	marginLeft :'-2px',
        	marginTop : '16px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getCommonTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearchBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]

    }]

});
