/**
 * @author Pankaj Sisodiya
 */
Ext.define('Academia.view.reports.student.StudentMembershipRequestReportSearchForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.studentMembershipRequestReportSearchForm',
	frame: true,
	plugins: "formlabelrequired",
	items: [{

		xtype: 'textfield',
		labelAlign: 'top',
		width: 226,
		name: 'requestMembershipType',
		fieldLabel: getServiceRequestTranslation('REQUEST_TYPE'),
		itemId: 'requestMembershipType',
		readOnly:true,
		value:"Buzz Sports Club Membership Request"
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'requestMembershipId',
			layout:'hbox',
			fieldLabel: getServiceRequestTranslation('REQUEST_ID'),
			store: 'servicerequest.studentservicerequest.StudentRequestStore',
			itemId: 'requestMembershipId',
			msgTarget: 'qtip',
			valueField: 'code',
			displayField: 'code',
			queryParam:'serviceRequestNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			labelAlign: 'top',
			width: 226,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'studentMembershipId',
			itemId:'studentMembershipId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentNameOrCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			minChars:3,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
		}]
	}, {
		xtype: 'customcombobox',
		name: 'genderMembership',
		itemId:'genderMembership',
		fieldLabel: getCommonTranslation('GENDER'),
		store: Ext.create('Academia.store.reports.servicerequest.StudentSportGenderStore'),
		valueField: 'id',
		displayField: 'value',
		queryParam:'studentNameOrCode',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		minChars:3,
		typeAhead:false,
		forceSelection:true,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		labelAlign: 'top',
		width: 226,
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			}
		}
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'datefield',
			itemId: 'startDateMembership',
			fieldLabel: getServiceRequestTranslation('FROM_DATE'),
			name: 'startDateMembership',
			vtype: 'daterange',
			endDateField: 'endDateMembership',
			maxValue : new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,

			editable: false
		}, {
			xtype: 'datefield',
			name: 'endDateMembership',
			itemId : 'endDateMembership',
			fieldLabel: getServiceRequestTranslation('TO_DATE'),
			vtype: 'daterange',
			startDateField: 'startDateMembership',
			maxValue : new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			editable: false
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
	}, {
		xtype: 'fieldcontainer',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchButtonMembershipId',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetButtonMembershipId',
			buttonAlign: 'right',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});