Ext.define('Academia.view.reports.systemutilization.loginFrequency.ModuleUsageGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.moduleusagegrid',
	title : getCommonTranslation('MODULE_ACCESS_REPORT'),
	border : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns : [{
		text : getCommonTranslation('USER_CODE'),
		dataIndex: 'code',
		flex: 1
	}, { 
		text : getPersonModuleTranslation('PRINT_NAME'),
		dataIndex : 'printName',
		flex: 1
	}, { 
		text : getCommonTranslation('LOGIN_PERIOD'),
		hidden : true,
		dataIndex : 'userLoginPeriod',
		flex: 1
	}, {
		text : getCommonTranslation('MODULE_NAME'),
		dataIndex : 'moduleName',
		flex: 1
	}, {
		text : getCommonTranslation('MENU_NAME'),
		dataIndex : 'menuName',
		flex: 1,
		renderer: function(obj) {
			return getMegaMenuTranslation(obj);
         }
	}, {
		text : getCommonTranslation('LOGIN_COUNT'),
		dataIndex : 'count',
		flex: 1
	}],
	 initComponent: function() {
	        var this$ = this;
	        this$.addExportToolBarItems(this$);
	        var store = this$.buildStore();
	        Ext.apply(this$, {
	            store: store,
	            dockedItems: [{
	                xtype: 'toolbar',
	                dock: 'bottom',
	                items: [{
	                    xtype: 'custompagingtoolbar',
	                    plugins: ['pagesize'],
	                    store: store,
	                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	                    displayInfo: true
	                }]
	            }]
	        });

	        this$.callParent(arguments);
	    },
	    buildStore: function() {
	       var store = Ext.create('Academia.store.reports.systemutilization.loginFrequency.LoginFrequencyGridStore');
	    	store.getProxy().api.read =SERVERURL.MODULE_USAGE_REPORT_BY_CRITERIA;
	    	 return store;
	    }
});