/**
 * Ankur Jaiswal
 */
Ext.define('Academia.view.reports.userroleprivilege.URPGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.urpgrid',
	store: 'reports.userroleprivilege.URPStore',
	title: getCommonTranslation('URP_REPORT'),
	border: true,
	width:1280,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'urptabstructure':1
		}
	},
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'reports.userroleprivilege.URPStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [],
	columns: [{
		header: getCommonTranslation('PORTAL'),
		dataIndex: 'portal',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			return value.value;
		}
	}, {
		header: getCommonTranslation('MODULE'),
		dataIndex: 'module',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			return value.value;
		}
	}, {
		header: getCommonTranslation('FEATURE'),
		dataIndex: 'feature',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			return value.value;
		}
	}, {
		header: getCommonTranslation('PRIVILEGE'),
		dataIndex: 'privilege',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			return value.value;
		}
	}, {
		header: getCommonTranslation('URP_ROLES'),
		dataIndex: 'rolesCount',
		flex: 1,
		sortable: true,
		renderer: function(value) {
			if (value > 0) {
				return '<a href="#">' + value + '</a>';
			} else {
				return value;
			}
		}
	}, {
		header: getCommonTranslation('URP_USERS'),
		dataIndex: 'usersCount',
		flex: 1,
		sortable: true,
		renderer: function(value, meta, record) {
			if (value > 0) {
				return '<a href="#">' + value + '</a>';
			} else {
				return "";
			}
		}
	}]
});