/**
 * Ankur Jaiswal
 */
Ext.define('Academia.view.reports.userroleprivilege.URPUserGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.urpusergrid',
    store: 'reports.userroleprivilege.URPUserStore',
    title: getCommonTranslation('URP_REPORT'),
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'reports.userroleprivilege.URPUserStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    tbar: [],
    columns: [{
        header: getCommonTranslation('PORTAL'),
        dataIndex: 'portal',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('MODULE'),
        dataIndex: 'module',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('FEATURE'),
        dataIndex: 'feature',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('PRIVILEGE'),
        dataIndex: 'privilege',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('ACADEMY_LOCATION'),
        dataIndex: 'academyLocation',
        flex: 1,
        sortable: true,
        renderer: function(value, meta, record) {
            return value;
        }
    }, {
        header: getCommonTranslation('URP_ROLES'),
        dataIndex: 'roles',
        flex: 1,
        sortable: true
    }, {
        header: getCommonTranslation('URP_USERS'),
        dataIndex: 'printName',
        flex: 1,
        sortable: true
    }]
});