/**
 * Akshay Sharma
 * 
 */
Ext.define('Academia.view.resourceutilization.ResourceUtilizationSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.resourceutilizationsearch',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'fieldcontainer',
		defaults : {
			labelAlign : 'top'
		},
		items : [{
			xtype : 'radiogroup',
			itemId:'selectionTypeId',
			defaults: {
				flex: 1
			},
			items : [{
				boxLabel : getProgramandcourseTranslation('MASTER_TIME_TABLE'),
				name:'resourceViewType',
				inputValue : 'masterTimetable',
				checked : true
			},{
				boxLabel : getProgramandcourseTranslation('DETAIL_TIME_TABLE'),
				name:'resourceViewType',
				inputValue : 'detailedTimetable',
			},{
				boxLabel : getCommonTranslation('EVENT'),
				name:'resourceViewType',	
				inputValue : 'event'
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'multiselectcombofield',
			name: 'academyLocation',
			itemId: 'academyLocationId',
			fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
			autoloadStore: false,
			width: 460,
			store : Ext.create('Academia.store.facilitiesresources.resourcebooking.AcademyLocationListByUserStore'),
			cls:'multiBrandCampusCls',
			displayField : 'value',
			valueField : 'id',
			allowBlank : false,
			queryParam:'nameOrCode',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'room',
			itemId: 'roomId',
			fieldLabel:getCourseTxCommonTranslation('Room'),
			store : Ext.create('Academia.store.resourceutilization.ResourcesStore'),
			displayField : 'value',
			valueField : 'id',
			queryParam:'name',
			minChars:3,
			typeAhead:true,
			queryMode:'remote',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'multiselectcombofield',
			name: 'faculty',
			itemId: 'facultyId',
			fieldLabel: getCommonTranslation('USER'),
			autoloadStore: false,
			width: 226,
			store : Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.FacultyCombo'),
			displayField : 'valueCode',
			valueField : 'id',
			queryParam:'nameOrCode',
			minChars:3,
			typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'bookingPurpose',
			itemId: 'bookingPurposeItemId',
			fieldLabel: getCommonTranslation('EVENT_PURPOSE'),
			store: Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceBookingPurposeStore'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			triggerAction: 'all',
			forceSelection: true,
			hidden:true
		}, {
			xtype: 'customcombobox',
			name: 'eventName',
			itemId: 'eventName',
			fieldLabel: getCommonTranslation('EVENT_NAME'),
			store : Ext.create('Academia.store.eventmeetingminutes.EMMMinuteReportsEventNameStore'),
			hidden:true,
			displayField : 'value',
			valueField : 'value',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			hidden:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'resources',
			itemId: 'resourcesItemId',
			fieldLabel:getCommonTranslation('RESOURCES'),
			store : Ext.create('Academia.store.resourceutilization.ResourcesStore'),
			displayField : 'value',
			valueField : 'id',
			queryParam:'name',
			hidden:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			minChars:3,
			typeAhead:true,
			queryMode:'remote',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
					afterRender: function(combo){
						combo.getStore().on("load", function(store, items){
							if(items.length==0)
								Ext.select('.x-boundlist-item').elements[0].hidden = true;
							else
								Ext.select('.x-boundlist-item').elements[0].hidden = false;
						});
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'userName',
				itemId: 'userNameItemId',
				fieldLabel:getCommonTranslation('USER'),
				store : Ext.create('Academia.store.resourceutilization.ActiveUserStore'),
				displayField : 'valueCode',
				valueField : 'id',
				queryParam:'name',
				hidden:true,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				minChars:3,
				typeAhead:true,
				queryMode:'remote',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							});
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'weekDay',
				itemId: 'weekDayId',
				fieldLabel: getProgramandcourseTranslation('WEEKDAY'),
				store:Ext.create('Academia.store.transport.serviceRoute.WeekDays'),
				displayField:'value',
				valueField:'id',
				typeAhead:true,
	            editable: false,
				forceSelection:true
			}]
		},{
			 xtype:'displayfield',
			 itemId:'eventDateItemId',
			 hidden:true,
			 value:'<b class="menu-title">'+getProgramandcourseTranslation('EVENT_DATE')+'</b>',
			 style: {
				 textDecoration: "underline"
			 }
		 },{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
				name : 'fromDate',
				itemId:'fromDate_Id',							
				format : CONSTANTS.DATE_FORMAT,
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				endDateField : 'toDate_Id',
				hidden:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('TO_DATE'),
				name : 'toDate',
				itemId:'toDate_Id',							
				format : CONSTANTS.DATE_FORMAT,
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				startDateField : 'fromDate_Id',
				hidden:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			 xtype:'displayfield',
			 itemId:'eventTimeItemId',
			 hidden:true,
			 value:'<b class="menu-title">'+getProgramandcourseTranslation('EVENT_TIME')+'</b>',
			 style: {
				 textDecoration: "underline"
			 }
		 },{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'timefield',
				name : 'fromTime',		
				itemId : 'fromTime',			
				fieldLabel:getProgramandcourseTranslation('START_TIME'),
				format:'g:i A',
				submitFormat : CONSTANTS.DISPLAY_TIME_FORMAT,
				vtype: 'timerange',
				endTimeField : 'toTime',
				listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				}
			},{
				xtype : 'timefield',
				name : 'toTime',		
				itemId : 'toTime',			
				fieldLabel:getProgramandcourseTranslation('END_TIME'),
				format:'g:i A',
				submitFormat : CONSTANTS.DISPLAY_TIME_FORMAT,
				vtype: 'timerange',
				startTimeField :'fromTime',
				listeners: {
					render: function(field) {
						return timeFormatRender(field);
					}
				}
			}]
		}],
		listeners:{
			render: function(myfieldset){
				myfieldset.setMargin('-10px');
			}
		}
	},{
		xtype: 'fieldcontainer',
		width: '100%',

		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind: true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}
	]
});
