/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.securitysetup.MultipleALandRolesGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.multiplealandrolesgrid',
	store: 'securitysetup.MultipleALandRolesGridStore',
	cls:'gridBodyScroller popWinPagination',
	title: getCommonTranslation('MULTIPLE_ACADEMY_LOCATION_ROLES'),
	border: true,
	frame:false,
	
	selType: 'checkboxmodel',
	selModel: {
		mode:'MULTI',
		checkOnly : false,
		showHeaderCheckbox: true,
	},
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH,
		disabled: true
	},{
		xtype: 'button',
		text: getCommonTranslation('SAVE'),
		itemId: 'saveDataBtn',
	}],
	columns: [{
		xtype: 'actioncolumn',
		header:  getCommonTranslation("PRIMARY_ACADEMY_LOCATION"),
		dataIndex:'primaryAcaLoc',
		flex:1,
		sortable:true,
		items: [{
			//icon: 'resources/images/radio_button.svg', 
			getClass: function(v, meta, rec) {
				return rec.get('primaryAcaLoc') ? 'al-roles-grid-radio-checked' : 'al-roles-grid-radio';
			},
			handler: function(grid, rowIndex, colIndex) {
				var scrollTop = grid.el.dom.scrollTop;
				var store = grid.getStore();
				var record = store.getAt(rowIndex);
				// Unselect all records
				store.each(function(rec) {
					rec.set('primaryAcaLoc', false);
					//grid.getSelectionModel().deselectAll();
				});
				// Select the clicked record
				record.set('primaryAcaLoc', true);
				//grid.getSelectionModel().select(record, true)
				
			    grid.el.dom.scrollTop = scrollTop;
			}
		}]
	},{
		header:  getCommonTranslation("ACADEMY_LOCATION"),
		dataIndex:'academyLocationName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation("START_DATE"),
		dataIndex: 'alStartDate',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation("TILL_DATE"),
		dataIndex: 'alTillDate',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation("ROLE"),
		dataIndex: 'role',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation("START_DATE"),
		dataIndex: 'roleStartDate',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation("TILL_DATE"),
		dataIndex: 'roleTillDate',
		flex:1,
		sortable:true
	}],
	listeners: {
        selectionchange: function(selModel, selected) {
            var deleteButton = this.down('#btnDelete');
            // Enable delete button only if one record is selected
            if (selected.length === 1) {
                deleteButton.setDisabled(false);
            } else {
                deleteButton.setDisabled(true);
            }
        }
    }
});