Ext.define('Academia.view.securitysetup.RoleBasicDetails',{
	extend:'Academia.view.common.IdGeneratorForm',
	formCode:'roleForm',
	alias:'widget.rolebasicdetails',
	titleCollapse: true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	defaults : {
		xtype:'textfield',
		labelAlign:'top',
		width: 452,
		//tdAttrs: { style: 'padding: 5px;' },
		enforceMaxLength : true
	},
	 plugins : "formlabelrequired",
	items:[{
			xtype:'hidden',
			name:'id'
	},{
		xtype:'hidden',
		name:'whetherDeleted'
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width: 'auto',
		defaults: {
			xtype:'textfield',
			width: 226,
			labelAlign: 'top',
			enforceMaxLength : true
		},
		items:[{		
			fieldLabel:getCommonTranslation('ROLE_ID'),
			name:'serialNumber',
			itemId:'serialNumber',
			//emptyText: getCommonTranslation('ID_AUTOGENERATE'),
			allowBlank:false,
			maxLength: 10,
		},{
			fieldLabel:getCommonTranslation('ROLE_NAME'),
			name:'name',
			allowBlank:false,
			maxLength : 35
		}]
	},{
        xtype     : 'textareafield',
        grow      : true,
        name      : 'description',
        width     : CONSTANTS.DEFAULT_TEXTAREA_WIDTH,
        fieldLabel: getCommonTranslation('ROLE_DESCRIPTION'),
        allowBlank:false
    },{
		   xtype: 'checkboxgroup',
           fieldLabel: getCommonTranslation('ACCESS_TO'),    
           width:496,    
           allowBlank:false,
           defaults : {
           getSubmitData: function() {
   	        var this$ = this,
   	            data = null,
   	            val;
   	        if (!this$.disabled && this$.submitValue && !this$.isFileUpload()) {
   	            val = this$.getSubmitValue();
   	            if (val !== null) {
   	            	var customValue = "{\"id\":" + val + "}";
   	   	            val = Ext.decode(customValue);
   	                data = {};
   	                data[this$.getName()] = val;
   	            }
   	        }
   	        return data;
   	    }
           },
           items:[{
        	   boxLabel:getCommonTranslation('CORE_ERP'),
        	  inputValue : 1,
        	   name:'portals'
           },{
        	   boxLabel:getCommonTranslation('EMPLOYEE_PORTAL'),
        	   inputValue : 2,
        	   name:'portals'
           },{
        	   boxLabel:getCommonTranslation('STUDENT_PORTAL'),
        	   inputValue : 3,
        	   name:'portals'
           },{
        	   boxLabel:getCommonTranslation('EXTERNAL_PORTAL'),
        	   inputValue : 4,
        	   name:'portals'
           },{
        	   boxLabel:getCommonTranslation('ADD_ON_MODULE_PORTAL'),
        	   inputValue : 5,
        	   name:'portals'
           },{
        	   boxLabel:getCommonTranslation('PARENT_PORTAL'),
        	   inputValue : 7,
        	   hidden:true,
        	   itemId: 'parentPortalItemId',
        	   name:'portals'
           },{
        	   boxLabel:getCommonTranslation('STUDENT_MOBILE_APP'),
        	   inputValue : 8,
        	   hidden:true,
        	   itemId: 'studentMobAppItemId',
        	   name:'portals'
           },{
        	   boxLabel:getCommonTranslation('PARENT_MOBILE_APP'),
        	   inputValue : 9,
        	   hidden:true,
        	   itemId: 'parentMobAppItemId',
        	   name:'portals'
           }]
	},{
		xtype:'fieldcontainer',
		defaults: {
			width: 452,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'mfa',
			itemId:'mfa',
			width:452,
			fieldLabel: getCommonTranslation('MULTI_FACTOR_AUTHENTICATION'),
			store: 'standardMaster.MultiFactorAuthenticationStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank: true
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'textarea',
			name: 'restrictedIPs',
			itemId: 'restrictedIPsItemId',
			fieldLabel: getCommonTranslation('RESTRICTED_IPS'),
			width: 452,
			enforceMaxLength : true,
			maxLength:1000,
	        regex:/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}(?:,\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})*$/i,
	        regexText :'Please verify the data entered, IP’s should be comma separated'
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'checkboxfield',
			name: 'isConcurrentLoginAllow',
			itemId:'isConcurrentLoginAllowItemId',
			boxLabel: getCommonTranslation('CONCURRENT_LOGIN_ALLOW'),
			width: 'auto',
			labelAlign: 'right',
			style: {
				marginTop: '25px',
				marginLeft: '10px'
			},
			inputValue : true,
			uncheckedValue: false ,
			checked: true
		}]
	},{
		xtype:'fieldcontainer',
		items:[{
    	xtype:'button',
    	text:getCommonTranslation('SAVE'),
    	formBind:true,
    	itemId:'btnSaveRoleId',
    	action:'save',
    	ui:'CustomBtnSubmit',
		scale:CONSTANTS.BUTTONSIZE
	},{
        xtype: 'button',
        text: getExaminationTranslation('RESET'),
        itemId: 'resetButtonId',
        ui: 'CustomBtnCancel',
        scale: CONSTANTS.BUTTONSIZE,
        handler: function() {
            this.up('form').getForm().reset();
        }
    }/*{
    	xtype:'button',
    	text:getCommonTranslation('CANCEL'),
    	action:'cancel',
    	itemId:'btnCancelSaveRoleId',
    	ui: 'CustomBtnCancel',
    	scale:CONSTANTS.BUTTONSIZE
}*/]
	}]	
});