/**
 * @author pritam.patil
 * this form is used for find track request
 */
Ext.define('Academia.view.servicerequest.FacultyFindRequestForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.facultyfindrequestform',
    frame : false,
    style : {
    	marginLeft:'10px'
    },
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textfield',
            name: 'REQUEST_ID',
            fieldLabel: getServiceRequestTranslation('REQUEST_ID'),
            itemId: 'request_id',
            msgTarget: 'qtip'
        },{
                xtype: 'customcombobox',
                fieldLabel: getPersonModuleTranslation('REQUESTER_NAME'),
                store: 'common.picklist.StudentSelectNameComboStore',
                editable: false,
                queryMode: 'local',
                name: 'selectedNameField',
                itemId: 'selectedNameField',
                valueField: 'id',
                displayField: 'value',
                value: 'FIRST_NAME'
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
                itemId: 'selectedName',
                name: 'REQUESTER_FIRSTNAME'
            }]},{
                xtype: 'fieldcontainer',
                width: '100%',
                layout: {
                    type: 'hbox'
                },
                defaults: {
                    width: 226,
                    labelAlign: 'top'
                },
                items: [{
        	xtype: 'customcombobox',
            name: 'STATUS',
            fieldLabel: getServiceRequestTranslation('STATUS'),
            itemId: 'status',
            editable: false,
            store: 'servicerequest.common.ServiceRequestStatus',
            displayField: 'value',
            valueField: 'id',
          //  queryMode: 'local',
            msgTarget: 'qtip'
        },{
            xtype: 'textfield',
            name: 'SLA_DAYS',
            fieldLabel: getServiceRequestTranslation('BEYOND_SLA'),
            itemId: 'beyond_SLA',
            msgTarget: 'qtip'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [ {
            xtype: 'datefield',
            name: 'FROM_DATE',
            fieldLabel: getServiceRequestTranslation('FROM_DATE'),
            itemId: 'from_date',
            msgTarget: 'qtip',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
	        endDateField : 'till_date',
	        vtype : 'daterange'
        }, {
            xtype: 'datefield',
            name: 'TILL_DATE',
            fieldLabel: getServiceRequestTranslation('TILL_DATE'),
            itemId: 'till_date',
            msgTarget: 'qtip',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
	        startDateField : 'from_date',
	        vtype : 'daterange'
        }]
    },{
    	 xtype: 'requestsubrequesttypefieldcontainer',
         itemId: 'requestTypeFieldContainer',
         layout:'hbox'
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('SEARCH'),
            itemId: 'facultyFindButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            itemId: 'facultyClearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});