
Ext.define('Academia.view.servicerequest.StudentTransferClosureWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.studenttransferclosurewin',
    title: getCommonTranslation('CLOSE_REQUEST'),
    autoScroll: true,
    maxHeight: 600,
    modal: true,
    items: [{
        xtype: 'form',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        plugins: "formlabelrequired",
        items: [{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('REQUEST_EXECUTED_ON'),
            name: 'executionDate',
            itemId: 'executionDateId',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: true,
        }, {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('CLOSURE_REASON'),
            name: 'closureReasonId',
            itemId: 'closureReasonId',
            store: 'servicerequest.common.ClosureReasons',
            valueField: 'id',
            displayField: 'value',
            allowBlank: false,
            editable: false
        },
        {
        	xtype: 'fieldcontainer',
        	width : '100%',
        	layout: {
        		type: 'hbox'
        	},
        	defaults: {
        		width: 235
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		boxLabel:getServiceRequestTranslation('RETAIN_STUDENT_DATA'),
        		name:'isRetainStudentData',
        		itemId:'retainStudentDataId',
        		checked:true
        	},{
        		xtype: 'checkboxfield',
        		boxLabel:getServiceRequestTranslation('RETAIN_ACADEMIC_DATA'),
        		name:'isRetainAcademicData',
        		itemId:'retainAcademicDataId',
        		checked:true
     
        	}]
        },{
        	xtype: 'fieldcontainer',
        	width : '100%',
        	layout: {
        		type: 'hbox'
        	},
        	defaults: {
        		width: 235
        	},
        	items: [{
        		xtype: 'checkboxfield',
        		boxLabel:getServiceRequestTranslation('RETAIN_SERVICES_OPTED'),
        		name:'isRetainServicesOpted',
        		itemId:'retainServicesOptedId',
        		checked:true
        	},{
        		xtype: 'checkboxfield',
        		boxLabel:getServiceRequestTranslation('RETAIN_FEE_PAYMENT_DATA'),
        		name:'isRetainFeesPaymentData',
        		itemId:'retainFeePaymentDataId',
        		checked:true
        	}]
        },{
            xtype: 'textareafield',
            name: 'remark',
            itemId: 'remark',
            allowBlank: true,
            fieldLabel: getServiceRequestTranslation('CLOSURE_RREMARKS')
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            cls : 'windowBtnPos',
    		style :{marginLeft: '-1px',marginTop:'10px'},
    		
            items: [{
            	xtype: 'button',
                itemId: 'formSubmitButtonId',
                action: 'Submit',
                text: getCommonTranslation('SUBMIT'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true,
                disabled: true
            },{
            	xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                action: 'Cancel',
                itemId: 'winCancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});