/**
 * @author Raghavendra.Soni
 * this window is for closing multiple service request
 */
Ext.define('Academia.view.servicerequest.TerminationRequestClosureWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.terminationrequestclosurewin',
    title: getCommonTranslation('CLOSE_REQUEST'),
    autoScroll: true,
    maxHeight: 600,
    modal: true,
    items: [{
        xtype: 'form',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        plugins: "formlabelrequired",
        items: [{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('REQUEST_EXECUTED_ON'),
            name: 'executionDate',
            itemId: 'executionDateId',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: true,
        }, {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('CLOSURE_REASON'),
            name: 'closureReasonId',
            itemId: 'closureReasonId',
            store: 'servicerequest.common.ClosureReasons',
            valueField: 'id',
            displayField: 'value',
            allowBlank: false,
            editable: false
        }, {
            xtype: 'textareafield',
            name: 'remark',
            itemId: 'remark',
            allowBlank: true,
            fieldLabel: getServiceRequestTranslation('CLOSURE_RREMARKS')
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            cls : 'windowBtnPos',
    		style :{marginLeft: '-1px',marginTop:'10px'},
    		
            items: [{
            	xtype: 'button',
                itemId: 'formSubmitButtonId',
                action: 'Submit',
                text: getCommonTranslation('SUBMIT'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true,
                disabled: true
            },{
            	xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                action: 'Cancel',
                itemId: 'winCancelBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});