/**
 * @author Pritam.Patil
 * approval Details Grid 
 */
Ext.define('Academia.view.servicerequest.common.ApprovalDetailsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.approvaldetailsgrid',
    //title: getServiceRequestTranslation('ESCALATE_HISTORY'),
    border: true,
//    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
        header: getServiceRequestTranslation('ACTION_TAKEN_BY'),
        dataIndex: 'user',
        renderer:function(object) {
			return object.value;
		},
        flex: .2
    },{
        header: getServiceRequestTranslation('ACTION_DATE'),
        dataIndex: 'actionDate',
        flex: .1,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getServiceRequestTranslation('REMARKS'),
        dataIndex: 'remarks',
        flex: .3
    },{
        header: getServiceRequestTranslation('ASSIGNED_USER'),
        dataIndex: 'escalatedApprover',
        renderer:function(object) {
			if(isNullOrEmpty(object)) {
				return null;
			} else {
				return object.value;
			}   	
        	
		},
        flex: .2
    },{
        header: getServiceRequestTranslation('ACTION_TYPE'),
        dataIndex: 'actionType',
        flex: .1
    }],
    initComponent: function() {
       var this$ = this;
       var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getServiceRequestTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
   buildStore: function() {
        return Ext.create('Academia.store.servicerequest.common.ApprovalDetails');
    }

});