Ext.define('Academia.view.servicerequest.common.BillDetailsGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.billdetailsgrid',
	//store:'servicerequest.common.BillDetailsGridStore',
	title:getServiceRequestTranslation('FEE_DETAILS'),
	border:true,
	viewConfig: {
        stripeRows: true
    },
	columns:[{
		header:getServiceRequestTranslation('BILL_NO'),
		dataIndex:'billNo',
		flex:0.1
	},{
		header:getServiceRequestTranslation('BILL_TYPE'),
		dataIndex:'raiseBillType',
		flex:0.1
	},{
		header:getServiceRequestTranslation('FEE_HEAD'),
		dataIndex:'feeHeadName',
		flex:0.1
	},{
		header:getServiceRequestTranslation('FEE_AMOUNT'),
		dataIndex:'feeAmount',
		flex:0.1
	},{
		header:getServiceRequestTranslation('DISCOUNT'),
		dataIndex:'discountAmount',
		flex:0.1
	},{
		header:getServiceRequestTranslation('AMOUNT_PAID'),
		dataIndex:'amountPaid',
		flex:0.1
	},{
		header:getServiceRequestTranslation('AMOUNT_PENDING'),
		dataIndex:'amountPending',
		flex:0.1
	},{
		header:getServiceRequestTranslation('BILL_DATE'),
		dataIndex:'billingDate',
		flex:0.1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:getServiceRequestTranslation('DUE_DATE'),
		dataIndex:'dueDate',
		flex:0.1,
		renderer:function(date) {
			return dateRender(date);
		}
	}],
	initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.servicerequest.common.BillDetailsGridStore');
    }
});