Ext.define('Academia.view.servicerequest.eventcalendar.EventCalendarSearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.eventcalendarsearch',
    autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('CALENDAR_NAME'),
            store : 'servicerequest.eventcalendar.AllEventCalendarName',
            editable : false,
            name: 'calendarId',
            itemId: 'calendarName',
            valueField: 'id',
            displayField: 'value'
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('ACADEMY_LOCATION'),
            store : 'common.AcademyLocationNameSeparated',
            editable : false,
            name: 'academyLocationId',
            itemId: 'academyLocationId',
            valueField: 'id',
            displayField: 'value'
        }]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            store : 'common.ProgramsByAcademyIdLocationId',
            name: 'programId',
            itemId: 'programId',
            valueField: 'id',
            displayField: 'valueCode',
            enforceMaxLength : true,
    		typeAhead: true,
            forceSelection: true,
            triggerAction: 'all',
            queryParam:'qry',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
 			listConfig: {
 				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
 				loadingText: getCommonTranslation('SEARCHING'),
 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
 				getInnerTpl: function() {
 					return '<div class="search-item">' +
 					'{value}' +
 					'</div>';
 				}
 			}
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('STATUS'),
            store : 'common.StatusComboStore',
            editable : false,
            name: 'status',
            valueField: 'id',
            displayField: 'name'
        }]
        },{
        	xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SEARCH'),
				itemId : 'searchButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				formBind:true,
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text : getCommonTranslation('RESET'),
				itemId : 'resetButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
       }]
		
});
