/**
 * @author Pritam.Patil
 * lack of attendance Details Grid 
 */
Ext.define('Academia.view.servicerequest.examrelatedrequest.examrequesttype.LackOfAttendanceGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.lackofattendancegrid',
    border: true,
    autoScroll: true,
    selModel:Ext.create('Ext.selection.CheckboxModel',{
    	singleSelect: true,
    	showHeaderCheckbox : false,
    	itemId : 'selModelId'
    }),
    viewConfig: {
        stripeRows: true
    },
    columns: [{
        header: getServiceRequestTranslation('COURSES'),
        dataIndex: 'courseName',
        sortable: true,
        flex: .2
    },{
        header: getServiceRequestTranslation('SESSION_ATTENDED'),
        dataIndex: 'attendedCount',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('SESSION_COUNDUCTED'),
        dataIndex: 'conductedCount',
        sortable: true,
        flex: .2
    },  {
        header: getServiceRequestTranslation('ATTENDANCE_PERCENTAGE'),
        dataIndex: 'attendancePercentage',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {
       var this$ = this;
       var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getServiceRequestTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
   buildStore: function() {
        return Ext.create('Academia.store.servicerequest.examrelatedrequest.Attendance');
    }

});