/**
 * @author pritam.patil
 * This is used for student DEbarment form 
 */
Ext.define('Academia.view.servicerequest.terminations.DebarmentForm', {
    extend: 'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.debarmentform',
    frame: false,
    border: false,
    autoScroll: true,
    plugins: "formlabelrequired",
    cls: 'serviceRequestMainPanelCls',
    items: [{
		xtype:'hidden',			
    	name:'id'
    },{
       	xtype:'hidden',			
      	name:'version'
  	},{
		xtype:'nestedJsonCombo',
		name:'assignee',
		itemId : 'assigneeId',
		hidden:true,
        width: 226
	},{
		xtype:'nestedJsonCombo',
		name:'serviceRequestSetting',
		itemId:'settingId',
		hidden:true,
        width: 226
	},{
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'requesterdetailspanel',
            itemId: 'requesterDetails',
            margin: 0
        }]
    }, {
        xtype: 'fieldset',
        title: getServiceRequestTranslation('DEBARMENT_REASON'),
        collapsed: false,
        items: [{
            xtype: 'fieldcontainer',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            layout: 'hbox',
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('PROGRAM'),
                store : Ext.create('Academia.store.servicerequest.programcoursesectiontransfer.DebarmentProgramStore'),
                name : 'programId',
                valueField: 'id',
                itemId: 'programDebarmentId',
                displayField: 'value',
                allowBlank: false,
                editable: false,
                queryMode : 'local'
            }, {
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('COURSE'),
                name: 'courseId',
                store: 'servicerequest.withdrawfromcourseprogramservice.Courses',
                valueField: 'id',
                itemId: 'courseDebarmentId',
                displayField: 'value',
                allowBlank: true,
                editable: false,
                queryMode : 'local'
            }]
        },{
		 xtype: 'fieldset',
		 collapsed: false,
		 itemId: 'leavingReasonsFieldset',
		 layout: 'vbox',
		 defaults:{
			 width:'100%'
		 },
		 style:{
				'padding-left': '0px !important;'
			 },
		 items: []
	 }, /*{
            xtype: 'fieldcontainer',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('DEBARMENT_REASON'),
                name: 'debarmentReasonId',
                store: 'servicerequest.DebarmentReasons',
                valueField: 'id',
                itemId: 'courseDebarmentId',
                displayField: 'value',
                allowBlank: false,
                editable: false
            }]
        },*/ {
            xtype: 'fieldcontainer',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            layout: 'hbox',
            items: [{
			xtype : 'customcombobox',
			name : 'academicTermId',
			itemId : 'academicTermId',
			allowBlank: false,
			disabled:true,
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store : Ext.create('Academia.store.user.UserAcademyTermsByALAndProgramStore'),
			valueField : 'id',
			displayField : 'value',
			editable: false,
	        listeners: {
	        	afterrender: function(cmp){
	        		setTimeout(function(){
		        		if(!cmp.isDisabled()){
		        			cmp.setDisabled(true);
		        			setTimeout(function(){
			        			cmp.setDisabled(false);
		        			},300);
		        		}
        			},2000);
	        	}
	        }
		},{
                xtype: 'datefield',
                fieldLabel: getServiceRequestTranslation('FROM_DATE'),
                name: 'fromDate',
                itemId :'fromDateId',
                allowBlank: false,
                vtype: 'daterange',
	            endDateField: 'toDateId',
	            listeners: {
	            	render: function(field) {
	            		return dateFormatRender(field);
	            	}
	            },
	          //--submitFormat: CONSTANTS.DATE_FORMAT
            }, {
                xtype: 'datefield',
                fieldLabel: getServiceRequestTranslation('TO_DATE'),
                name: 'toDate',
                allowBlank: false,
                itemId : 'toDateId',
                vtype: 'daterange',
	            startDateField: 'fromDateId',
	            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT
            }]
        }, {
            xtype: 'fieldcontainer',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            layout: 'vbox',
            width:700,
            items: [{
                xtype: 'textareafield',
                name: 'remarks',
                itemId : 'remarks_Id',
                width: 460,
                maxLength : 255,
                enforceMaxLength : true,
                allowBlank: false,
                fieldLabel: getServiceRequestTranslation('DEBARMENT_REMARKS')
            },{
	        	xtype:'checkbox',
	        	name: 'whetherUnenrollFromCourses',
	        	boxLabel: getCommonTranslation('WHETHER_UN-ENROLL_FROM_COURSES'),
	        	itemId:'WhetherUnenrollFromCoursesItemId',
	        	inputValue: true,
				uncheckedValue: false,
				style:{
					marginTop: '20px !important'
				},
	        },{
	        	xtype:'checkbox',
	        	name: 'whetherAcademicTermSkip',
	        	boxLabel: getCommonTranslation('WHETHER_ACDEMIC_TERM_SKIP'),
	        	itemId:'whetherAcademicTermSkipId',
	        	inputValue: true,
				uncheckedValue: false,
				hidden:true
				
	        },{
	        	xtype:'checkbox',
	        	name: 'whetherCompletionProcessSkip',
	        	boxLabel: getCommonTranslation('WHETHER_COMPLETION_PROCESS_SKIP'),
	        	itemId:'whetherCompletionProcessSkipId',
	        	inputValue: true,
				uncheckedValue: false,
				hidden:true
				
	        },{
                xtype: 'livesearchcombo',
                width: 226,
                labelAlign: 'top',
                name: 'userId',
                allowBlank: false,
                fieldLabel: getServiceRequestTranslation('INITIATED_BY'), 
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),//default assignee 
                itemId: 'user_Id'
            }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveDebarment',
                text: getServiceRequestTranslation('UPLOAD_DOC'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
                ui: 'CustomBtnSubmit',
                itemId: 'withdrawButtonId',
                hidden: true,
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});