/**
 * @author Pritam.Patil
 * This component is used  to show transaction View Grid
 */
Ext.define('Academia.view.setup.dashboard.UserViewGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.userviewgrid',
    title : getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: true
    },
    columns: [{
    	 header: getCommonTranslation('ID'),
        dataIndex: 'id',
        hidden: true
    },
    {
        header: getCommonTranslation('USER'),
        dataIndex: 'userName',
        align: 'center',
        sortable: true,
        flex: .2
    },{
        header: getCommonTranslation('TRANSACTION'),
        dataIndex: 'transactionCode',
        align: 'center',
        sortable: true,
        flex: .4
    }, {
        header: getCommonTranslation('DATE'),
        dataIndex: 'transactionDate',
        align: 'center',
        sortable: true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getCommonTranslation('TIMES_USED'),
        dataIndex: 'count',
        align: 'center',
        sortable: true,
        renderer  : function(Value) {
            return '<a href="#">'+Value+'</a>';
        },
        flex: .2

    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
       return Ext.create('Academia.store.setup.dashboard.TransactionViewStore');
    }
});