/**
 * @author pritam.patil
 * this form is used for student track request
 */
Ext.define('Academia.view.setup.dashboard.UserViewSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.userviewsearchform',
    frame: false,
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'livesearchcombo',
 			name: 'userId',
 			fieldLabel: getPersonModuleTranslation('USER'),
 			emptyText :getCommonTranslation('TYPE_3_CHAR'),
 			itemId : 'user'
       }, {
            xtype: 'datefield',
            name: 'startDate',
            fieldLabel: getServiceRequestTranslation('FROM_DATE'),
            itemId: 'from_date',
            msgTarget: 'qtip',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT
        }, {
            xtype: 'datefield',
            name: 'endDate',
            fieldLabel: getServiceRequestTranslation('TILL_DATE'),
            itemId: 'till_date',
            msgTarget: 'qtip',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
    	   xtype: 'customcombobox',
           fieldLabel: getCommonTranslation('NATURE_OF_TRANSACTION'),
           store: 'setup.dashboard.NatureOfTransactions',
           editable: false,
           name: 'transactionCode',
           width: 462,
           itemId: 'natureOfTransactionId',
           valueField: 'value',
           displayField: 'value'
       },{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('NATURE_OF_CHANGE'),
            store: 'setup.dashboard.NatureOfChanges',
            editable: false,
            queryMode: 'local',
            name: 'operationModeId',
            itemId: 'natureOfChangeId',
            valueField: 'id',
            displayField: 'value'
       }]
     },{
        xtype: 'fieldcontainer',
        width: '100%',
        style :{
        	marginLeft : '-2px',
        	marginTop : '10px' 
        },
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('SEARCH'),
            itemId: 'findButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            listeners : {
            	click : function(button){
            		this.up('form').getForm().reset();
            	}
            }
        }]
    }]
});