/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.setup.manageportalpermission.StudentPortalManagePermissionSetupGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.studentportalmanagepermissionsetupgrid',
	store:'setup.manageportalpermission.ManagePortalPermissionSetupGridStore', 
	border: true,
	autoScroll: false,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store:'setup.manageportalpermission.ManagePortalPermissionSetupGridStore', 
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype:'button',
		text:getCommonTranslation('SAVE'),
		action:'save',
		itemId:'saveStdPortalPermissions'
	}],
	columns: [{
		header:getCommonTranslation('MODULE_NAME'),
		dataIndex:'moduleName',
		flex:0.1,
		sortable:false,
		renderer:function(value) {
			return getPortalSetupNew(value);
		}	
	},{
		xtype:'checkcolumn',
		header:getCommonTranslation('EDITABLE'),
		flex:.1,
		sortable:false,
		dataIndex : 'isEditable',
	},{
		header:  getCommonTranslation("ADDITIONAL_SETUP"),
		dataIndex: 'additionalSetup',
		flex:.1,
		sortable:true,
		renderer:function(value, meta, record){
			    return '<a href="#">Setup</a>';
		}
	}],
	plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    },
});
