/**
 * @author pritam.patil
 * this form is used for view sponsorship's past data search form 
 */
Ext.define('Academia.view.sponsorship.sponsorshipListing.ViewSponsorshipsPastDataSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.viewsponsorshipspastdatasearchform',
    frame: false,
    cls:'customSearchPanel',
    //title: getCommonTranslation('QUICK_SEARCH'),
    items: [
    	{
        xtype: 'fieldcontainer',
        //width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [ {
            xtype: 'customcombobox',
            name: 'PROGRAM_ID',
            store: 'common.ProgramsByAcademyIdLocationId',
            itemId: 'program',
            fieldLabel: getCommonTranslation('PROGRAM'),
            editable: false,
            valueField: 'id',
            displayField: 'value'
        },{
            xtype: 'customcombobox',
            name: 'BATCH_ID',
            itemId: 'batch',
            fieldLabel: getCommonTranslation('BATCH'),
            store: 'common.BatchesByProgramId',
            disabled:true,
            editable: false,
            displayField: 'value',
            valueField: 'id'
        },{
            xtype: 'customcombobox',
            itemId:'period',
            disabled:true,
            editable: false,
            displayField: 'value',
            valueField: 'id',
            store:'admission.applications.admissionAndMidTermAdmission.PeriodComboStore',
            fieldLabel: getCommonTranslation('PERIOD'),
            name: 'PROG_BATCH_PERIOD_CONFIG_ID'
        }]
    },{
        xtype: 'fieldcontainer',
        //width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            /*xtype: 'textfield',
            fieldLabel: getCommonTranslation('STUDENT_ID'),
            name: 'STUDENT_ID',
            itemId: 'studentId',
            msgTarget: 'qtip'
        }, {
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('STUDENT_NAME'),
            name: 'STUDENT_NAME',
            itemId: 'studentName',
            msgTarget: 'qtip'*/
        	
        	xtype: 'customcombobox',
			name:'STUDENT_ID',
			itemId:'studentId',
			store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
			fieldLabel:getCommonTranslation('STUDENT_CODE_NAME'),
			valueField: 'code',
			displayField: 'valueCode',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code / value}' +
					'</div>';
				}
			}
        },{
            xtype: 'textfield',
            name: 'SPONSOR_ID',
            fieldLabel: getCommonTranslation('SPONSOR_Id'),
            itemId: 'sponsorId',
            msgTarget: 'qtip'
        }]
     },{
        xtype: 'fieldcontainer',
        //width: '100%',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textfield',
            name: 'SPONSOR_NAME',
            fieldLabel: getCommonTranslation('SPONSOR_NAME'),
            itemId: 'sponsorName',
            msgTarget: 'qtip'
        },{
            xtype: 'datefield',
            name: 'BILLING_DATE_FROM',
            fieldLabel: getCommonTranslation('BILLING_DATE_FROM'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'sto_date',
            vtype: 'daterange',
            endDateField: 'from_date',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        },{
            xtype: 'datefield',
            name: 'BILLING_DATE_TO',
            fieldLabel: getCommonTranslation('BILLING_DATE_TO'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            itemId: 'from_date',
            vtype: 'daterange',
            startDateField: 'sto_date',
            maxValue: new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
        }]
    },{
        xtype: 'fieldcontainer',
       // width: '100%',
        style : {
       	 marginTop : '10px '
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'findButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearch',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            listeners: {
                click: function(button, eOpts) {
                	this.up('form').getForm().reset();
                	this.up('form').down('#batch').setDisabled(true);
                	this.up('form').down('#period').setDisabled(true);
                }
            }
        }]
    }]
});