Ext.define('Academia.view.standardMaster.StandardMasterScreen', {
	extend: 'Ext.Panel',
	alias: 'widget.standardMaster',
	frame: true,
	autoScroll: true,
	padding:0,
	layout:'vbox',
	defaults:{
		border: true,
		margin: 5,
		width:'100%'
	},
	title: 'Standard Master Management',
	items: [{
		xtype:'fieldcontainer',
		layout:'hbox',
		items:[{
			xtype: 'groupingcombobox',
			itemId: 'standardMasterComboField',
			name: 'standardMasterCombo',
			width:400,
			labelAlign:'top',
			queryMode: 'local',
			groupField: 'code',
			groupDisplayField: 'code',
			store: 'standardMaster.StandardMasterStore',
			fieldLabel: getCommonTranslation('STANDARD_MASTER_COMBO'),
			displayField: 'value',
			valueField: 'id' ,
			minChar : 3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			}
		// queryParam : 'masterName',
		// typeAhead:true
		},{
			xtype: 'customcombobox',
			itemId: 'activePaymentGatewayCombo',
			name: 'activePaymentGatewayCombo',
			hidden:true,
			width:400,
			labelAlign:'top',
			/*queryMode: 'local',
			groupField: 'code',
			groupDisplayField: 'code',*/
			store: 'standardMaster.OSMAllPaymentGateWayStore',
			fieldLabel: getCommonTranslation('ACTIVE_PAYMENT_GATEWAY'),
			displayField: 'value',
			valueField: 'id' ,
			minChar : 3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: 'No active payment gateway'
			},
			 listeners: {
			        expand: function(combo) {
			            combo.getStore().load();  //api is same for pop up grid and dropdown
			        }
			    },
		},{
			xtype:'displayfield',
			itemId: 'paymentGatewayConfig',
			name: 'paymentGatewayConfig',
			hidden:true,
			labelWidth:440,
			cls:'paymentGatewayCSMCls',
			value: '<img src="resources/images/SetupNew.svg" style="vertical-align:middle;margin-right:5px;" />'+getCommonTranslation('PAYMENT_GATEWAY_CONFIGURATION'),
			//labelSeparator:'',
		    //fieldLabel: '<img src="resources/images/SetupNew.svg" style="vertical-align:middle;margin-right:5px;" />'+getCommonTranslation('PAYMENT_GATEWAY_CONFIGURATION'),
		    style:{
		    	marginTop:'18px !important',
		    }
		}]
	},{
		xtype:'panel',
		width:'100%',
		border:false,
		items:[{
			xtype: 'stdMasterParentGrid',
			itemId: 'stdMasterParentGrid',
			style:'marginLeft:2px !important',
			cls:'gridDynamicBackgroundImageCls'
		}]
	},
	/*{
        title: getCommonTranslation('STD_MASTER_GRID'),
        itemId: 'stdMasterParentGrid',
        xtype: 'grid',
        layout: 'fit',
        columns: [],
        columnLines: true,
        hidden: true,
        selType:'checkboxmodel',
        selModel: {
    		multiSelect :true,
    		mode:'SIMPLE',
    		checkOnly : false
    	},
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS,
//            emptyText: getCommonTranslation('SELECT_RECORD_TO_SHOW_DATASET'),
            deferEmptyText: false
        },
        tbar: [{
            xtype: 'button',
            itemId: 'btnAdd',
            tooltip : getCommonTranslation('ADD'),
            glyph: ICONGLYPH.ADDGLYPH
        }, {
            xtype: 'button',
            itemId: 'btnEdit',
            tooltip : getCommonTranslation('EDIT'),
            glyph: ICONGLYPH.EDITGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnView',
	        tooltip : getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'	
	    },{
            xtype: 'button',
            itemId: 'btnDelete',
            cls: 'CustomToolbarBtnReject',
            tooltip : getCommonTranslation('DELETE'),
            glyph: ICONGLYPH.DELETEGLYPH
        }],
        dockedItems: [{
            xtype: 'toolbar',
            dock: 'bottom',
            items: [{
                xtype: 'custompagingtoolbar',
                plugins: ['pagesize'],
                store: this.store,
                emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                displayInfo: true
            }]
        }]
    },*/ {
		title: getCommonTranslation('STD_MASTER_CHILD_GRID'),
		itemId: 'stdMasterChildGrid',
		hidden: true,
		xtype: 'grid',
		cls:'gridDynamicBackgroundImageCls',
		columns: [],
		overflowX: 'hidden',
		columnLines: true,
		selType:'checkboxmodel',
		emptyText: getCommonTranslation('SELECT_RECORD_TO_SHOW_DATASET'),
		selModel: {
			multiSelect :true,
			mode:'SIMPLE',
			checkOnly : false
		},
		headerFix:{
			headerFix: true,
			portalIdsWithStructure: {
				'standardMaster':1
			}
		},
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS,
			deferEmptyText: false
		},
		tbar: [{
			xtype: 'button',
			itemId: 'btnAdd',
			tooltip : getCommonTranslation('ADD'),
			iconCls:'icon-addbutton',
			cls:'addbutton'
		}, {
			xtype: 'button',
			itemId: 'btnEdit',
			tooltip : getCommonTranslation('EDIT'),
			iconCls:'icon-editbutton',
			cls:'editbutton'
		}, {
			xtype: 'button',
			itemId: 'btnView',
			tooltip : getCommonTranslation('VIEW'),
			iconCls: 'icon-View',
			cls:'iconView'			
		},{
			xtype: 'button',
			itemId: 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip : getCommonTranslation('DELETE'),
			iconCls: 'icon-Delete',
			cls:'iconDelete'
		}],
		dockedItems: [{
			xtype: 'toolbar',
			dock: 'bottom',
			items: [{
				xtype: 'custompagingtoolbar',
				plugins: ['pagesize'],
				store: this.store,
				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo: true
			}]
		}]
	}]
});
