/**
 * @author Amit G
 */
Ext.define('Academia.view.student.disciplinaryActionsReport.StudentDisciplinaryActionsReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentdisciplinaryactionsreportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
	     		xtype: 'customcombobox',
	     		name:'studentId',
	     		itemId:'studentId',
	     		store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch',
	     		fieldLabel : getCommonTranslation('STUDENT_ADMISSION_ID_CODE_NAME'),
	     		valueField: 'id',
	 			displayField: 'valueCode',
	 			queryParam:'name',
	     		minChars:3,
	     		typeAhead:false,
	     		width:490,
	     		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	     		enableKeyEvents  : 'true',
	     		hideTrigger:false,
	     		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	     		triggerAction: '',
	     		forceSelection:true,
	     		listConfig: {
	     			listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 					}
	 				},
	     			loadingText: getCommonTranslation('SEARCHING'),
	     			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	     			getInnerTpl: function() {
	     				return '<div class="search-item">' +
	     				'{value} / {code}' +
							'</div>';
	     			}
	     		}
	     	},{
				xtype : 'customcombobox',
				name : 'programGroupCombo',
				itemId: 'programGroupCombo',
				fieldLabel : getCommonTranslation('DISCIPLINARY_ACTION_REPORT_PROGRAM_GROUP'),
				store: 'admission.applicationFormSale.ProgramGroupComboStore',
				valueField: 'id',
				forceSelection:true,
	            displayField: 'value',
	            editable: false
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
	            	 xtype: 'customcombobox',
		    			name:'PROGRAM_NAME',
		    			itemId:'programId',
		    			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    			valueField: 'id',
		    			displayField: 'code',
		    			queryParam:'name',
		    			minChars:3,
		    			allowBlank: true,
		    			typeAhead:false,
		                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                forceSelection:true,
		                listeners: {
    						render: function(combo) {
		                         //var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
		                    	  var store = Ext.create('Academia.store.common.AssignedProgramStore');
		                         combo.bindStore(store);
		                     }
    					},listConfig: {
    		                listeners: {
    		                    beforeshow: function(picker) {
    		                    picker.minWidth = picker.up('combobox').getSize().width;
    		                    }
    		                    },
    		                    loadingText: getCommonTranslation('SEARCHING'),
    		                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    		                    getInnerTpl: function() {
    		                    return '<div class="search-item">' +
    		                    '{code} / {value}'+
    		                    '</div>';
    		                    }
    		                    }
		    		
		            },{
		                 xtype: 'customcombobox',
		                 name: 'BATCH_NAME',
		                 itemId: 'batchId',
		                 fieldLabel: getPersonModuleTranslation('BATCH'),
		                 disabled:true,
		                 editable: false,
		                 queryMode: 'local',
		                 displayField: 'value',
		                 valueField: 'id',
		                 listeners: {
		                     render: function(combo) {
		                         //var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
		                    	 var store = Ext.create('Academia.store.common.CurrentBatchStore');
		                         combo.bindStore(store);
		                     }
		                 }
		             },{
		                 xtype: 'customcombobox',
		                 itemId:'periodId',
		                 disabled:true,
		                 editable: false,
		                 displayField: 'value',
		                 valueField: 'id',
		                 queryMode: 'local',
		                 fieldLabel: getPersonModuleTranslation('PERIOD'),
		                 name: 'PERIOD_NAME',
		                 listeners: {
		                     render: function(combo) {
		                         var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
		                         combo.bindStore(store);
		                     }
		                 }
		             }]
			}]
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
		                 xtype: 'customcombobox',
		                 name: 'SECTION',
		                 itemId: 'section',
		                 disabled:true,
		                 fieldLabel: getPersonModuleTranslation('SECTION'),
		                 editable: false,
		                 queryMode: 'local',
		                 valueField: 'sectionId',
		                 displayField: 'sectionCode',
		                 listeners: {
		                     render: function(combo) {
		                         var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
		                         combo.bindStore(store);
		                     }
		                 }
		             },{
		 	        	xtype: 'customcombobox',
			            fieldLabel: getPersonModuleTranslation('TYPE_OF_INCIDENT'),
			            itemId: 'incidentType',
			            name: 'incidentType',
			            store:'personinfo.common.disciplinaryactivity.DisciplinaryTypeOfIncidentSearchCombo',
			            queryParam:'term',
			            triggerAction: 'all',
			            forceSelection: true,
						displayField: 'value', 
						valueField: 'id',
			        }]
			}]
		
		},{

			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
					xtype: 'datefield',
					name: 'startDate',
					itemId:'startDate',
					allowBlank:true,
					maxValue: new Date(),
					//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					vtype: 'daterange',
					endDateField: 'endDate',
					editable:false,
					fieldLabel: getPersonModuleTranslation('START_DATE')
				},{
					xtype: 'datefield',
					name: 'endDate',
					itemId:'endDate',
					allowBlank:true,
					vtype: 'daterange',
					startDateField: 'startDate',
					editable:false,
					maxValue: new Date(),
					//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					fieldLabel: getPersonModuleTranslation('END_DATE')
				}]
			}]
		
		
		
		},
		{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				//formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});