/**
 * 
 * @author Amit G
 */
Ext.define('Academia.view.student.postGraduateManagement.StudentExaminersReportGrid', {
	alias: 'widget.studentexaminersreportgrid',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	title: getCommonTranslation('STUDENT_EXAMINERS_REPORT'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns : [ {
		header: getCommonTranslation('EXAMINER_ID'),
		dataIndex: 'functionaryID',
		flex:1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.functionaryID.code+"/"+record.data.functionaryID.value;
			}                        
		}
	},{
		header: getCommonTranslation('EXAMINERS_REPORT_NAME'),
		dataIndex: 'name',
		flex:1
	},{
		header: getCommonTranslation('EXAMINERS_REPORT_LAST_NAME'),
		dataIndex: 'lastName',
		hidden:true,
		flex:1
	},{
		header: getCommonTranslation('EXAMINER_TYPE'),
		dataIndex: 'functionaryType',
		flex:1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.functionaryType.value;
			}                        
		}
	},{
		header: getCommonTranslation('UPLOAD_DOCUMENT'),
		dataIndex: 'uploadDocument',
		sortable: false,
		flex:1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record)) {
				if(record.data.examinersReportDocuments.length>1) {					
					return '<a href=#>'+record.data.examinersReportDocuments.length+'<a>';
				} else if(record.data.examinersReportDocuments.length==1) {
					return '<a href=#>'+record.data.examinersReportDocuments[0].name+'<a>';
				} 
			}                        
		}
	},{
		header: getCommonTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		hidden:true,
		flex:1,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header : getCommonTranslation('AUDIT_ID'),
		dataIndex : 'auditId',
		flex:1,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.auditId.code;
			}                        
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.postGraduateManagement.StudentExaminersReportStore');
	}
});