/**
 * 
 * @author Vyabha Thakur
 */
Ext.define('Academia.view.student.postGraduateManagement.StudentJointDegreeGrid', {
	alias: 'widget.studentjointdegreegrid',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	title: getCommonTranslation('STUDENT_JOINT_DEGREE'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],
	columns : [ {
		header: getCommonTranslation('COLLABORATION_AGREEMENT_TYPE'),
		dataIndex: 'collaborationAgreementType',
		ItemId: 'collaborationAgreementTypeItem',
		sortable: true,
		hidden:false,
		flex:1.5
	},{
		header : getCommonTranslation('PARTNER_INSTITUTION_1'),
		dataIndex : 'partnerInstitution1',
		ItemId: 'partnerInstitution1Item',
		flex:1,
		hidden:false,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.partnerInstitution1.value
			}                        
		}
	},{
		header : getCommonTranslation('PARTNER_INSTITUTION_COUNTRY_1'),
		dataIndex : 'partnerInstitutionCountry1',
		ItemId: 'partnerInstitutionCountry1Item',
		flex:1.5,
		hidden:false,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.partnerInstitutionCountry1.value
			}                        
		}
	},{
		header: getCommonTranslation('PARTNER_INSTITUTION_2'),
		dataIndex: 'partnerInstitution2',
		ItemId: 'partnerInstitution2Item',
		sortable: true,
		hidden:true,
		flex:1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.partnerInstitution2.value
			}                        
		}
	},{
		header : getCommonTranslation('PARTNER_INSTITUTION_COUNTRY_2'),
		dataIndex : 'partnerInstitutionCountry2',
		ItemId: 'partnerInstitutionCountry2Item',
		flex:1,
		hidden:true,
		sortable:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.partnerInstitutionCountry2.value
			}                        
		}
	},{
		header: getCommonTranslation('CERTIFICATE_TEXT'),
		dataIndex: 'certificate',
		ItemId: 'certificateTextItem',
		sortable: true,
		hidden:false,
		flex:1,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){
			if(!isNullOrEmpty(value)){
				metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
				metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 17px;max-height: 60px;min-width: 16ch;max-width: 17ch;';
				metaData.tdCls ="student-thesis-column-cls";
				return value;
			}	
		}    
	},{
		header : getCommonTranslation('FEES_EXEMPTED_PER_YEAR'),
		dataIndex : 'feesExemptedPerYear',
		ItemId: 'feesExemptedPerYearItem',
		flex:1,
		hidden:true,
		sortable:true
	},{
		header: getCommonTranslation('FEES_EXEMPTED_PER_YEAR_REASON'),
		dataIndex: 'feesExemptedPerYearReason',
		ItemId: 'feesExemptedPerYearReasonItem',
		flex: 1,
		hidden:true,
		sortable: true
	},{
		header : getCommonTranslation('IFR_REDUCED'),
		dataIndex : 'ifrReduced',
		ItemId: 'ifrReducedItem',
		flex:1,
		sortable:true,
		hidden:true
	},{
		header : getCommonTranslation('IFR_REDUCED_REASONS'),
		dataIndex : 'ifrReducedReason',
		ItemId: 'ifrReducedReasonItem',
		flex:1,
		sortable:true,
		hidden:true
	},{
		header : getPersonModuleTranslation('UPLOAD_DOCUMENT'),
		dataIndex: 'studentJointDegreeDocuments',
		flex:1,
		sortable:true,
		renderer:function(value, meta, record){
			console.log('record='+record)
			if(!isNullOrEmpty(value)) {
				if(record.data.studentJointDegreeDocuments.length>1) {					
					return '<a href=#>'+record.data.studentJointDegreeDocuments.length+'<a>';
				} else if(record.data.studentJointDegreeDocuments.length==1) {
					return '<a href=#>'+record.data.studentJointDegreeDocuments[0].name+'<a>';
				} 
			}                        
		}
	},{
		header: getCommonTranslation('AUDIT_DATE'),
		dataIndex: 'auditDate',
		ItemId: 'auditDateItem',
		sortable: true,
		hidden:true,
		flex: .2,
		renderer : function(value){
			return  dateRender(value);   	
		}
	},{
		header: getCommonTranslation('AUDIT_ID'),
		dataIndex: 'auditId',
		ItemId: 'auditIdItem',
		flex: 1,
		sortable: true,
		hidden:true,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				return record.data.auditId.code;
			}                        
		}
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.student.postGraduateManagement.StudentJointDegreeStore');
	}
});