Ext.define('Academia.view.student.studentFeePayerReport.DocumentListFeePayerReportInnerGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.documentlistfeepayerreportinnergrid',
	border:true,
	autoScroll:false,
	initComponent: function() {    	     
		var grid=this;
		var store=Ext.create('Academia.store.student.report.DocumentListFeePayerReportGridStore');
		Ext.apply(this, {
			store: store        
		});
		this.callParent(arguments);
		var custompagingtoolbar=grid.down('custompagingtoolbar');
		if(custompagingtoolbar){
			custompagingtoolbar.bindStore(store);        	
		}
	},
	tbar: [],
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo: true
		}]
	}],
	columns : [{
		header: getCommonTranslation('DOCUMENT_NAME'), 
		dataIndex: 'documentName',      
		flex: .5
	}, {
		header: getCommonTranslation('DOCUMENT_TYPE'), 
		dataIndex: 'documentType',
		itemId: 'documentTypeItem',
		flex: .5,
		renderer: function(value, metadata, record) {
			var msg = "";
			if (!isNullOrEmpty(record.data.documentType)) {
				msg = '<a href="#">' + record.data.documentType + '</a>';
			}else {
				if (!isNullOrEmpty(record.data.documentName)) {
					msg = '<a href="#">' + record.data.documentName + '</a>';
				}
			}
			return msg;
		}
	}, {
		header: getCommonTranslation('SUBMISSION_DATE'),
		dataIndex: 'submissionDate',	
		flex: .3,
		renderer : function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('STATUS'),
		dataIndex: 'status',
		flex: .3
	}]

});
