/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.student.studentFeePayerReport.StudentStartRegistrationWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.studentstartregistrationwin',
	title: getCommonTranslation('START_REGISTRATION'),
	frame: true,
	autoScroll:true,
	modal:true,
	//height:360,
	method: 'POST',
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		items: [{
			xtype:'fieldcontainer',
			layout:'vbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
            	xtype : 'datefield',
				fieldLabel : getCommonTranslation('START_DATE'),
				name : 'fromDate',
				itemId : 'fromDate',
				endDateField : 'toDate',
				vtype : 'daterange',
				allowBlank:false,
				minValue:new Date(),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
						Ext.defer(function() {
							obj.nextSibling().clearInvalid();
						},1000, this);
					}
				}
            }, {
            	xtype : 'datefield',
				fieldLabel : getCommonTranslation('END_DATE'),
				name : 'toDate',
				itemId : 'toDate',
				startDateField : 'fromDate',
				allowBlank:false,
				minValue:new Date(),
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
				}
              }]
		},{
				xtype:'fieldcontainer',
				items: [{
					xtype: 'button',
					action: 'Submit',
					text: getFeeAndPaymentCommonTranslation('SAVE'),
					formBind: true,
					itemId: 'submitBtn',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					text: getFeeAndPaymentCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					itemId: 'cancelBtn',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
	}]
});