/**
 * @author Dharmendra.p
 */

Ext.define('Academia.view.studentPortal.attendancereport.StudentPortalAttendanceGrid',{
					extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
					alias : 'widget.studentportalattendancegrid',
					title : getMegaMenuTranslation('SP_COURSE_ATTENDANCE'),
					border : true,
					autoScroll : true,
					refreshStoreData:true,
					viewConfig : {
						stripeRows : CONSTANTS.STRIPEROWS
					},
					columns : [{
						header : getProgramandcourseTranslation('PROGRAM_NAME'),
						dataIndex : 'programName',
						hidden:true,
						flex:.1
					},{
						header : getProgramandcourseTranslation('BATCH'),
						dataIndex : 'batchName',
						hidden:true,
						flex:.1
					},{
						header : getProgramandcourseTranslation('PERIOD'),
						dataIndex : 'periodName',
						hidden:true,
						flex:.1
					},{
						header : getCommonTranslation('COURSE_CODE'),
						dataIndex : 'courseCode',
						sortable : true,
						flex : .1
					}, {
						header : getCommonTranslation("COURSE_NAME"),
						dataIndex : 'courseName',
						sortable : true,
						flex : .1
					}, {
						header : getProgramandcourseTranslation('TOTAL_RECORDS'),
						dataIndex : 'totalRecords',
						flex:.1,
						renderer : function(value,records) {
							if(value>0){
								return '<a href="#">'+value+'</a>';
							}else{
								return "0";
							}
						}
					},{
						header : getProgramandcourseTranslation('TOTAL_PRESENT'),
						dataIndex : 'presentRecords',
						flex:.1,
						renderer : function(value,records) {
							if(value > 0){
								return '<a href="#">'+value+'</a>';
							}else{
								return "0";
							}
						}
					}, {
						header : getProgramandcourseTranslation('TOTAL_PRESENT_PERCENT'),
						dataIndex : 'presentPercentage',
						flex:.1,
						renderer : function(value,records) {
							if(value > 0){
								return value+"%";
							}else{
								return "0%";
							}
						}
					}, {
						header : getProgramandcourseTranslation('TOTAL_ABSENT'),
						dataIndex : 'absentRecords',
						flex:.1,
						renderer : function(value,records) {
							if(value > 0){
								return '<a href="#">'+value+'</a>';
							}else{
								return "0";
							}
						}
					}, {
						header : getProgramandcourseTranslation('TOTAL_ABSENT_PERCENT'),
						dataIndex : 'absentPercentage',
						flex:.1,
						renderer : function(value,records) {
							if(value > 0){
								return value+"%";
							}else{
								return "0%";
							}
						}
					}],

					initComponent : function() {
						var this$ = this;
						var store = this$.buildStudentStore();//(this$.personType == 'STUDENT') ? this$.buildStudentStore() : this$.buildFacultyStore();
						Ext.apply(this$,{
							store : store,
							dockedItems : [ {
								xtype : 'toolbar',
								dock : 'bottom',
								items : [ {
									xtype : 'custompagingtoolbar',
									plugins : [ 'pagesize' ],
									store : store,
									emptyMsg : getCommonTranslation('EMPTY_MESSAGE'),
									displayInfo : true
								} ]
							} ]
						});
						this$.addExportToolBarItems(this$);
						this$.callParent(arguments);
					},
					buildStudentStore : function() {
						return Ext.create('Academia.store.attendance.attendancereport.AttendanceReportGrid');
					}
				});