/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.studentportalangularloginsetup.StudentPortalAngularLoginConfigureScreen', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentportalangularloginconfigurescreen',
    plain: true,
    autoScroll: true,
    layout: 'vbox',
    defaults: {
        width: '100%'
    },
    items: [
    		{
    			xtype: 'fieldset',
    			title: getCommonTranslation('LOGIN_PAGE_CONFIGURATION'),
    			layout: 'vbox',
    		    defaults: {
    		        width: '100%'
    		    },
    			items:[
		        {
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                width: 226
		            },
		            items: [
		            	{
		            		xtype: 'hidden',
		            		name: 'id'
		            	},
		            	{
		            		xtype: 'hidden',
		            		name: 'logoUrlHidden'
		            	},
		            	{
		            		xtype: 'hidden',
		            		name: 'backgroundImgUrlHidden'
		            	},
		            	{
		            		xtype: 'hidden',
		            		name: 'uploadIcon1UrlHidden'
		            	},
		            	{
		            		xtype: 'hidden',
		            		name: 'uploadIcon2UrlHidden'
		            	},
		            	{
		            		xtype: 'hidden',
		            		name: 'uploadIcon3UrlHidden'
		            	},
		            	{
		            		xtype: 'hidden',
		            		name: 'forgotPwdLogoUrlHidden'
		            	},
		            	{
		            	xtype: 'fieldcontainer',
			            layout: 'vbox',
			            itemId:'uploadLogoContainerId',
			            defaults: {
			                labelAlign: 'top',
			                width: 226
			            },
			            items: [{
		        			xtype : 'filefield',
		        			fieldLabel: getCommonTranslation('UPLOAD_LOGO'),
		                    name: 'logoUpload',
				    		margin: '0 10 0 0',
				    		ui: 'CustomBtnSubmit'
		        		},{ 
		        			xtype: 'displayfield',
		        			itemId: 'logoUploadLink',
		        			value: '<a href=#><b class="menu-title">' + getPersonModuleTranslation('MD_VIEW_DOCUMENT') + '</b></a>',
		        			style: {
		        				marginTop: '-4px',
		        				textDecoration: "underline",
		        			}
		        		}]},{
			            	xtype: 'fieldcontainer',
				            layout: 'vbox',
				            defaults: {
				                labelAlign: 'top',
				                width: 226
				            },
				            items: [{
			        			xtype : 'filefield',
			        			fieldLabel: getCommonTranslation('UPLOAD_BACKGROUND_IMAGE'),
			                    name: 'backgroundImageUpload',
					    		margin: '0 10 0 0',
					    		ui: 'CustomBtnSubmit'
			        		},{ 
			        			xtype: 'displayfield',
			        			itemId: 'backgroundImageUploadLink',
			        			value: '<a href=#><b class="menu-title">' + getPersonModuleTranslation('MD_VIEW_DOCUMENT') + '</b></a>',
			        			style: {
			        				marginTop: '-4px',
			        				textDecoration: "underline",
			        			}

			        		}]},
		 
		                {
		                    xtype: 'checkboxfield',
		                    boxLabel: getCommonTranslation('SAME_AS_FORGOT_PASSWORD_PAGE'),
		                    name: 'sameAsForgotPasswordPage',
			            	margin: '25 0 0 0',
			            	hidden:true
		                }
		            ]
		        },
		        {
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                width: 226
		            },
		            items: [
		                {
		                    xtype: 'textfield',
		                    fieldLabel: getCommonTranslation('WELCOME_MESSAGE'),
		                    name: 'welcomeMessage',
		                    maxLength: 25
		                },
		                {
		                    xtype: 'textfield',
		                    fieldLabel: getCommonTranslation('USERNAME_LABEL'),
		                    name: 'usernameLabel'
		                },
		                {
		                    xtype: 'textfield',
		                    fieldLabel: getCommonTranslation('PASSWORD_LABEL'),
		                    name: 'passwordLabel'
		                },
		                {
		                    xtype: 'textfield',
		                    fieldLabel: getCommonTranslation('SUBMIT_BTN_LABEL'),
		                    name: 'submitBtnLabel'
		                }
		            ]
		        },
		        {
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
			            labelAlign: 'top',
			        },
		            items: [
		            	{
			            	xtype: 'checkboxfield',
			            	boxLabel: getCommonTranslation('DO_YOU_WANT_ANY_OTHER_LOGIN_OPTIONS'),
			            	name: 'otherLoginOptions',
							margin: '10 0 0 0'
		            	},
						{
							xtype: 'checkboxfield',
							boxLabel: getCommonTranslation('DO_YOU_WANT_GOOGLE_SSO'),
							name: 'googleSSO',
							margin: '10 0 0 12'
							
						}
		            ]
		        },
		        {
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                width: 226
		            },
		            items: [
		            	{
		            		xtype: 'customcombobox',
		            		name: 'ssoProvider',
		            		itemId: 'ssoProviderId',
		            		store: Ext.create('Ext.data.Store', {
		            			fields: ['id', 'value'],
		            			data: [{
		            				id: '1',
		            				value: 'Azure'
		            			}, {
		            				id: '2',
		            				value: 'ADFS'
		            			}]
		            		}),
		            		displayField: 'value',
		            		valueField: 'id',
		            		forceSelection: true,
		            		editable: false,
		            		fieldLabel: getCommonTranslation('SSO_PROVIDER'),
		            		allowBlank: true
		            	},
		            	{
		            		xtype : 'textfield',
		            		fieldLabel : getCommonTranslation('CUSTOMIZE_LABEL'),
		            		name: 'customizeLabel'
		            	},
		            	{
		            		xtype : 'textfield',
		            		fieldLabel : getCommonTranslation('REDIRECTION_URLS'),
		            		name: 'redirectionUrls',
		            		width: 460
		            	}
		            ]
		        }]
		},
		{
			xtype: 'fieldset',
			title: getCommonTranslation('HOW_TO_GUIDES_INSTRUCTIONS_CONFIGURATION'),
			layout: 'vbox',
		    defaults: {
		        width: '100%'
		    },
			items:[
		        {
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
			            labelAlign: 'top',
			        },
		            items: [
		            	{
			            	xtype: 'checkboxfield',
			            	boxLabel: getCommonTranslation('ENABLE_HOW_TO_GUIDE'),
			            	name: 'enableHowToUserGuide',
			            	margin: '10 0 0 0',
		            	},
						{
							xtype: 'checkboxfield',
							boxLabel: getCommonTranslation('TERMS_&_CONDITIONS'),
							name: 'termsAndConditionsCheck',
							margin: '10 0 0 12'
						}
		            ]
		        },{
			    	xtype: 'fieldcontainer',
			    	layout: 'hbox',
			    	defaults: {
			    		labelAlign: 'top'
			    	},
			    	items:[{
			    		xtype : 'textfield',
			    		fieldLabel : getCommonTranslation('HOW_TO_GUIDE_TITLE_TEXT'),
			    		name: 'howToGuideTitleText',
			    		width: 460
			    	}]
			    },
		        {
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                width: 226
		            },
		            items: [
		            	{
			            	xtype: 'fieldcontainer',
				            layout: 'vbox',
				            defaults: {
				                labelAlign: 'top',
				                width: 226
				            },
				            items: [ {
			        			xtype : 'filefield',
			        			fieldLabel: getCommonTranslation('ICON'),
			                    name: 'guidelineIcon1',
					    		margin: '0 10 0 0',
					    		ui: 'CustomBtnSubmit'
			        		},{ 
			        			xtype: 'displayfield',
			        			itemId: 'guidelineIcon1Link',
			        			value: '<a href=#><b class="menu-title">' + getPersonModuleTranslation('MD_VIEW_DOCUMENT') + '</b></a>',
			        			style: {
			        				marginTop: '-4px',
			        				textDecoration: "underline",
			        			}

			        		}]},    		
		               
			        		{
			        			xtype: 'textfield',
			        			fieldLabel: getCommonTranslation('LABEL_NAME'),
			        			name: 'guidelineLabel1'
			        		},
			        		{
			        			xtype: 'textfield',
			        			fieldLabel: getCommonTranslation('REDIRECTION_URLS'),
			        			name: 'guidelineUrl1'
			        		}
		            ]
		        },
		        {
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                width: 226
		            },
		            items: [{
		            	xtype: 'fieldcontainer',
			            layout: 'vbox',
			            defaults: {
			                labelAlign: 'top',
			                width: 226
			            },
			            items: [   {
		        			xtype : 'filefield',
		        			fieldLabel: getCommonTranslation('ICON'),
		                    name: 'guidelineIcon2',
				    		margin: '0 10 0 0',
				    		ui: 'CustomBtnSubmit'
		        		},{ 
		        			xtype: 'displayfield',
		        			itemId: 'guidelineIcon2Link',
		        			value: '<a href=#><b class="menu-title">' + getPersonModuleTranslation('MD_VIEW_DOCUMENT') + '</b></a>',
		        			style: {
		        				marginTop: '-4px',
		        				textDecoration: "underline",
		        			}

		        		}]},
		              
		                {
		                    xtype: 'textfield',
		                    fieldLabel: getCommonTranslation('LABEL_NAME'),
		                    name: 'guidelineLabel2'
		                },
		                {
		                    xtype: 'textfield',
		                    fieldLabel: getCommonTranslation('REDIRECTION_URLS'),
		                    name: 'guidelineUrl2'
		                }
		            ]
		        },
		        {
		            xtype: 'fieldcontainer',
		            layout: 'hbox',
		            defaults: {
		                labelAlign: 'top',
		                width: 226
		            },
		            items: [{
		            	xtype: 'fieldcontainer',
			            layout: 'vbox',
			            defaults: {
			                labelAlign: 'top',
			                width: 226
			            },
			            items: [   {
		        			xtype : 'filefield',
		        			fieldLabel: getCommonTranslation('ICON'),
		                    name: 'guidelineIcon3',
				    		margin: '0 10 0 0',
				    		ui: 'CustomBtnSubmit'
		        		},{ 
		        			xtype: 'displayfield',
		        			itemId: 'guidelineIcon3Link',
		        			value: '<a href=#><b class="menu-title">' + getPersonModuleTranslation('MD_VIEW_DOCUMENT') + '</b></a>',
		        			style: {
		        				marginTop: '-4px',
		        				textDecoration: "underline",
		        			}

		        		}]},
		                
		                {
		                    xtype: 'textfield',
		                    fieldLabel: getCommonTranslation('LABEL_NAME'),
		                    name: 'guidelineLabel3'
		                },
		                {
		                    xtype: 'textfield',
		                    fieldLabel: getCommonTranslation('REDIRECTION_URLS'),
		                    name: 'guidelineUrl3'
		                }
		            ]
		        }
			]
		},
		{
			xtype: 'fieldset',
			title: getCommonTranslation('FORGOT_PASSWORD_CONFIGURATION'),
			layout: 'vbox',
		    defaults: {
		        width: '100%'
		    },
		    items:[{
		    	xtype: 'fieldcontainer',
		    	layout: 'hbox',
		    	defaults: {
		    		labelAlign: 'top',
		    		width: 226,
		    		margin: '0 10 0 0'
		    	},
		    	items: [
		    		{
		            	xtype: 'fieldcontainer',
			            layout: 'vbox',
			            defaults: {
			                labelAlign: 'top',
			                width: 226
			            },
			            items: [ {
			    			xtype : 'filefield',
			    			fieldLabel: getCommonTranslation('UPLOAD_LOGO'),
			    			name: 'forgotPasswordLogo',
			    			ui: 'CustomBtnSubmit'
			    		},{ 
		        			xtype: 'displayfield',
		        			itemId: 'forgotPasswordLogoLink',
		        			value: '<a href=#><b class="menu-title">' + getPersonModuleTranslation('MD_VIEW_DOCUMENT') + '</b></a>',
		        			style: {
		        				marginTop: '-4px',
		        				textDecoration: "underline",
		        			}

		        		}]},
		    		{
		    			xtype: 'textfield',
		    			fieldLabel: getCommonTranslation('USERNAME_LABEL'),
		    			name: 'forgotPasswordUsernameLabel'
		    		},
		    		{
		    			xtype: 'textfield',
		    			fieldLabel: getCommonTranslation('FORGOT_PASSWORD_LINK_LABEL'),
		    			name: 'forgotPasswordLinkLabel'
		    		}
		    		]
		    },{
		    	xtype: 'fieldcontainer',
		    	layout: 'vbox',
		    	defaults: {
		            labelAlign: 'top',
		            width: '100%',
		            margin: '0 10 10 0'
		        },
		    	items:[{
		    		xtype : 'radiogroup',
		    		fieldLabel : getCommonTranslation('DO_YOU_WANT_CAPTCHA_VERIFICATION'),
		    		name: 'capthaVerificationRequired',
		    		defaults: {
		                margin: '5 20 5 0' // Add spacing between buttons
		            },
		    		height: 65,
		    		layout: 'hbox',
		    		items:[{ 
		    			boxLabel: getCommonTranslation('YES'), 
		    			name: 'capthaVerificationRequired', 
		    			inputValue: true,
		    			checked:true
		    		},{ 
		    			boxLabel: getCommonTranslation('NO'), 
		    			name: 'capthaVerificationRequired', 
		    			inputValue: false
		    		}]
		    	}]
		    },{
		    	xtype: 'fieldcontainer',
		    	layout: 'hbox',
		    	defaults: {
		    		labelAlign: 'top'
		    	},
		    	items:[{
		    		xtype : 'textfield',
		    		fieldLabel : getCommonTranslation('REDIRECTION_URLS'),
		    		name: 'captchaRedirectUrl',
		    		width: 460
		    	}]
		    }]
			},{
    xtype: 'fieldset',
    title: getCommonTranslation('THEME_COLOR_CONFIGURATION'),
    layout: 'vbox',
    defaults: {
        width: '100%'
    },
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 250,
            margin: '0 10 0 0'
        },
        items: [
            {
                xtype: 'component',
                fieldLabel: getCommonTranslation('PRIMARY_COLOR'),
				name : 'primaryColor',
				cls: 'primaryColor',
                autoEl: {
                    tag: 'div',
                    html: '<input type="color" id="colorPicker" value="#13829e" style="width:80px;height:40px;border:none;cursor:pointer;"><input type="text" id="hexInput" value="#13829e" maxlength="7" style="margin-left:10px;width:100px;"><div id="hexCode" style="margin-top:5px;font-weight:bold;color:#13829e;display:none;">Selected Color: #13829e</div>'
                },
                listeners: {
                    afterrender: function () {
                        var colorInput = Ext.get('colorPicker'),
                            hexInput = Ext.get('hexInput'),
                            hexCode = Ext.get('hexCode');

                        function updateColor(newColor) {
                            colorInput.dom.value = newColor;
                            hexInput.dom.value = newColor;
                            hexCode.dom.textContent = "Selected Color: " + newColor;
                            hexCode.setStyle('color', newColor);
                        }

                        // Sync when color picker changes
                        colorInput.on('input', function () {
                            updateColor(colorInput.dom.value);
                        });

                        // Sync when hex typed
                        hexInput.on('input', function () {
                            var val = hexInput.dom.value.trim();
                            if (/^#([0-9A-Fa-f]{6})$/.test(val)) {
                                updateColor(val);
                            }
                        });
                    }
                }
            }
        ]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        items: [
          {
			    		xtype : 'fieldset',
			    		title : getCommonTranslation('NOTE')+ ' : <span class="msg-not">' +getCommonTranslation( 'THEME_CONFIG') +'</span>',
    					flex: 1
			   }]
    }]
}
,
		{
			xtype : 'fieldcontainer',
			width : '100%',
			items : [{
				xtype : 'button',
				action : 'Submit',
				text : getCommonTranslation('SAVE'),
				formBind : true,
				itemId : 'saveSPLoginConfigBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE
			}, {
				xtype : 'button',
				text : getCommonTranslation('RESET'),
				ui : 'CustomBtnCancel',
				itemId : 'resetSPLoginConfigBtn',
				scale : CONSTANTS.BUTTONSIZE
			}]

		} 
    ]
});
