Ext.define('Academia.view.sunsuccess.SunSuccessNewFlagGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sunsuccessnewflaggrid',
	border:true,
	plugins:"formlabelrequired",
	title:getCommonTranslation('FLAG_CONFIGURATION_DETAILS'),
	itemId:'newflagridpanelid',
	initComponent: function() {
		var me = this;
		var flagColorStore = Ext.getStore('sunsuccess.SunSuccessFlagColorStore');
		flagColorStore.load();
		me.columns = [{ 
			header: getCommonTranslation('Id'),
			dataIndex : 'id',
			hidden:true,
			hideable: false
		},{
			header : getCommonTranslation('S_NO'),
			xtype: 'rownumberer',
			flex: 0.5,
			align: 'left',
			dataIndex : 'serialNumber'
		},{
			header : getCommonTranslation('FROM_SCORE') + ' <span class="required" style="color:red"> *</span>',
			dataIndex : 'fromScore',
			editor: {
				xtype: 'numberfield',
				//	allowBlank: false,
				name: 'fromScore',
				itemId: 'fromscoreId',
				maxLength: 6,
				minValue: -100.00,
				maxValue: 100.00,
				allowDecimals:true,
				decimalPrecision :2,
				useNull : true,
				fixPrecision : function(value){
					var me = this,
					    nan = isNaN(value),
					    precision = me.decimalPrecision;
					if (nan || !value) {
						return nan ? '' : value;
					}
					else if (!me.allowDecimals || precision <= 0) {
						precision = 0;
					}
					str = value.toString();
					if(str.indexOf(".") > 0){
						str = str.slice(0, (str.indexOf(".")) + precision + 1);
					}
					return Number(str); 
				},
				listeners: {
					blur: function(cmp) {
						var record = cmp.up('grid').getSelectionModel().getSelection()[0];
						var storedata = cmp.up('grid').getStore().data.items;
						var tillScore = record.get('tillScore');
						var value = cmp.getValue();
						if(value && value >= tillScore && tillScore) {
							showWarningMessage(getCommonTranslation('ALERT'), 'Till Score should be only greater than From Score');
							Ext.defer(function() {
								record.set('fromScore', "");
								record.resumeEvent('blur');
							}, 10)
						}
						if(Ext.isEmpty(value)) {
							record.set('fromScore', '');
						}
						storedata.forEach(function(obj){
							if(obj.data['serialNumber'] != record['data']['serialNumber'] && value && value >= obj.data['fromScore'] && value <= obj.data['tillScore']){
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('FROM_SCORE_ALREADY_EXIST'));
								Ext.defer(function() {
									record.set('fromScore', "");
									record.resumeEvent('blur');
								}, 10)
								return;
							}
						});
					}
				}
			},
			flex:1,
			itemId:'fromMapping',
			align: 'left',
			sortable: false,
			allowBlank: false,
			renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				if(Ext.isEmpty(val)) {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
				else {
					return val;
				}
			}
		},{
			header : getCommonTranslation('TILL_SCORE') + ' <span class="required" style="color:red"> *</span>',
			dataIndex : 'tillScore',
			flex:1,
			allowBlank: false,
			sortable: false,
			editor: {
				xtype: 'numberfield',
				useNull : true,
				name: 'tillScore',
				itemId: 'tillscoreId',
				maxLength: 6,
				minValue: -100.00,
				maxValue: 100.00,
				allowDecimals:true,
				decimalPrecision :2,
				fixPrecision : function(value){
					var me = this,
						nan = isNaN(value),
						precision = me.decimalPrecision;
					if (nan || !value) {
						return nan ? '' : value;
					}
					else if (!me.allowDecimals || precision <= 0) {
						precision = 0;
					}
					str = value.toString();
					if(str.indexOf(".") > 0){
						str = str.slice(0, (str.indexOf(".")) + precision + 1);
					}
					return Number(str); 
				},
				listeners: {
					blur: function(cmp) {
						var record = cmp.up('grid').getSelectionModel().getSelection()[0];
						var storedata = cmp.up('grid').getStore().data.items;
						var frmScore = record.get('fromScore');
						var value = cmp.getValue();
						if(value && value <= frmScore) {
							showWarningMessage(getCommonTranslation('ALERT'), 'Till Score should be only greater than From Score');
							Ext.defer(function() {
								record.set('tillScore', "");
								record.resumeEvent('blur');
							}, 10)
						}
						if(Ext.isEmpty(value)) {
							record.set('tillScore', '');
						}
						storedata.forEach(function(obj){
							if(obj.data['serialNumber'] != record['data']['serialNumber'] && value >= obj.data['fromScore'] && value <= obj.data['tillScore']){
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('TILL_SCORE_ALREADY_EXIST'));
								Ext.defer(function() {
									record.set('tillScore', "");
									record.resumeEvent('blur');
								}, 10)
								return;
							}

							if(obj.data['serialNumber'] != record['data']['serialNumber']  && frmScore <= obj.data['fromScore'] && value >= obj.data['tillScore']){
								showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('TILL_SCORE_ALREADY_EXIST'));
								Ext.defer(function() {
									record.set('tillScore', "");
									record.resumeEvent('blur');
								}, 10)
								return;
							}
						})
					}
				}
			},
			renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				/*if((val || val === 0) && val < rec.record.data.fromScore){
					//Ext.Msg.alert('Till value should not less than from value')
					//record.set('tillScore', "");
					showWarningMessage(getCommonTranslation('ALERT'), 'Till value should not less than from value');
					return '';
				}*/
				if(Ext.isEmpty(val)) {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
				else {
					return val;
				}
			}
		},{
			header : getCommonTranslation('FLAG_COLOR') + ' <span class="required" style="color:red"> *</span>',
			dataIndex : 'flagColorId',
			flex:1,
			sortable: true,
			editor: {	        	
				xtype: 'combobox',
				itemId: 'flagcolorId',
				name: 'flagColorId', 
				store:Ext.create('Academia.store.sunsuccess.SunSuccessFlagColorStore'),
				valueField:'id',
				displayField:'value',
				forceSelection: true,
				autoSelect: false,
				allowBlank:false,
				listeners: {
					select: function(cmp) {
						var record = cmp.up('grid').getSelectionModel().getSelection()[0];
						storedata = cmp.up('grid').getStore().data.items;
						var tillScores = record.get('tillScore');
						var value = cmp.getValue();
						storedata.forEach(function(obj){
							if(obj.data['serialNumber'] != record['data']['serialNumber'] && obj.data['flagColorId'] === value){
								showWarningMessage(getCommonTranslation('ALERT'), cmp.rawValue+' '+getCommonTranslation('COLOR_ALREADY_EXIST'));
								Ext.defer(function() {
									record.set('flagColorId', "");
									cmp.setValue("");
									cmp.resumeEvent('blur');
								}, 10)
								return;
							}
						});
					},
					blur: function(cmp) {
						var record = cmp.up('grid').getSelectionModel().getSelection()[0];
						if(Ext.isEmpty(cmp.getValue())) {
							record.set('flagColorId', '');
							cmp.disable();
						}
					}
				}
			},
			renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				var colorRec = flagColorStore.findRecord('id', val);
				if(colorRec) {
					return colorRec.get('value');
				}
				else {
					//return '';
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
			}
		},{
			header : getCommonTranslation('NOTIFICATION_EVENT'),
			dataIndex : 'notificationEventId', 
			editor: {
				xtype: 'customcombobox',
				displayField: 'value',
				valueField: 'code',
				forceSelection: true,
				autoSelect: false,
				store: {
					fields: [ 'value', 'code'],
					data : []
				}
			},
			flex:1,
			sortable: false,
			renderer: function(val, rec) {
				if(Ext.isEmpty(val)) {
					rec.tdCls = 'gridInputCustomStyle';
					return getExaminationTranslation('CLICK_TO_ENTER');
				}
				else {
					return val;
				}
			}
		}, {
			header:'Delete', //getServiceRequestTranslation('EMM_DELETE'),
			dataIndex: 'deleteButton',
			flex: 0.5,
			cls: 'CustomBodyBtnSettings',
			tooltip : getCommonTranslation('DELETE'),
			sortable: false,
			renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				try {
					if(record.get('isEditable') == 'VIEW') {
						return '';
					}
				}
				catch(error) {
					console.log(error);
				}
				if(record.store.data.length <= 1){
					if(!Ext.isEmpty(record.data.fromScore) && !Ext.isEmpty(record.data.tillScore) && record.data.flagColorId){
						return "<div class='deleteButtonClsForGridActionCls' data-qtip='Delete'  style='marginRight: 20 auto !important'></div>";
					}
					else{
						return '';
					}																
					/*}else{
	    		   return "<div class='deleteButtonClsForGridActionCls' data-qtip='Delete'  style='marginRight: 20 auto !important'></div>";
	    	   }*/
				}
				else{
					return "<div class='deleteButtonClsForGridActionCls' data-qtip='Delete'  style='marginRight: 20 auto !important'></div>";
				}
			}
		}, {
			header: 'Add',//getServiceRequestTranslation('EMM_ADD'),
			dataIndex: 'addButton',
			flex: 0.5,
			cls: 'CustomBodyBtnSettings',
			tooltip : getCommonTranslation('ADD'),
			glyph: ICONGLYPH.ADDGLYPH,
			sortable: false,
			renderer: function(value, meta, record, rowIndex, colIndex, store, view) {
				try {
					if(record.get('isEditable') == 'VIEW') {
						return '';
					}
				}
				catch(error) {
					console.log(error);
				}
				if(meta.recordIndex < 9){
					if(record.store.data.length-1 == meta.recordIndex && !Ext.isEmpty(record.data.fromScore) && !Ext.isEmpty(record.data.tillScore) && record.data.flagColorId){
						return "<div class='addButtonClsForGridActionCls' data-qtip='Add' style='marginRight: 20 auto !important'></div>";
					}
					else{
						return '';
					}
				}
				else{
					return '';
				}
			}
		}];
		this.callParent(arguments);     
	},
	plugins: [{
		ptype: 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(obj, editor, context) {
				editor.column.field.enable();
				if (editor.record.data.isEditable == 'ADD') {
					return true;
				} else if (editor.record.data.isEditable == 'EDIT') {
					return true;
				} else if (editor.record.data.isEditable == 'VIEW') {
					return false;
				}
			}
		}
	}]
});

var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
	clicksToEdit: 1,
	listeners: {
		beforeedit: function(editor, context, e) {}
	}
});