Ext.define('Academia.view.survey.sendSurvey.SendSurveyPBSGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sendsurveypbsgrid',
	title: getCommonTranslation('LIST_OF_COURSE_VARIANTS'),
	border: true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'sendsurveystructure':1
		}
	},
	tbar: [{
		xtype: 'button',
		itemId: 'createNewSurveyPBSBtn',
		text: getCommonTranslation('CREATE_NEW_SURVEY'),
		disabled: true
	}],
	columns: [{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.3,
		sortable: true
	}, {
		header: getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.3,
		sortable: true
	}],
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});
		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.survey.SendSurveyCreatePBSLevelSurveyGridStore');
	}
});