Ext.define('Academia.view.taskmanagement.AttachmentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.attachmentgrid',
	store :'taskmanagement.TaskManagementAttachmentStore',
	border: true,
	frame:false,
	enableColumnHide :false,
	selType:'checkboxmodel',
	//autoScroll:true,
	cls:'horizontalScrollingFixed',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getCommonTranslation('LIST_OF_FILES_LOGS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'taskmanagement.TaskManagementAttachmentStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
	this.callParent(arguments);
	},
	
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnDeleteSU',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
				
	},'->',{
		xtype : 'button',
		itemId : 'downloadDocumentSUItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind : true,
		cls: 'marginDownloadBtn'
		//margin:'1px 0px 0px -12px'
	}],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		sortable: false,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getCommonTranslation('FILES_NAMES'),
		dataIndex : 'documentName',
		flex: 1,
		sortable: false,
		renderer:function(value,rec){
			if(value){
				return "<a href='#'>"+value+"</a>";
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'creationDateTime',
		flex: 1,
		sortable: false,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header : getCommonTranslation('UPLOADED_BY'),
		dataIndex : 'userName',
		flex: 1,
		sortable: false
		/*renderer: function(date) {
            return dateRender(date);
        }*/
	}]
});