/**
 * @author Bhartendu Bhaskar
 * 
 */
Ext.define('Academia.view.taskmanagement.TMMyTasksFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.tmmytasksfilter',
    autoScroll: true,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'datefield',
            name: 'fromDate',
            itemId: 'fromDateItemId',
            vtype: 'daterange',
            endDateField: 'toDateItemId',
            fieldLabel: getServiceRequestTranslation('FD_FROM_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            allowBlank: false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDateItemId',
            vtype: 'daterange',
            startDateField: 'fromDateItemId',
            fieldLabel: getServiceRequestTranslation('FD_TO_DATE'),
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            allowBlank: false,
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: 'taskStatus',
            itemId: 'taskStatusItemId',
            fieldLabel: getServiceRequestTranslation('EMM_TASK_STATUS'),
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false,
            store: 'eventmeetingminutes.EventMeetingMinutesStatusStore',
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        cls: 'windowBtnPos',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnTmmytasksfilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetTmmytasksfilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});