/**
 * @author sumit.meena
 */
Ext.define('Academia.view.transport.reports.JourneyAssignmentFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.journeyassignmentfilter',
	autoScroll: false,
	frame: false,
	border:false,
	plugins : "formlabelrequired",
	cls:'customSearchPanel',
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('REPORT_VIEW'),
			name: 'detailView',
			itemId: 'detailView',
			store: 'transport.reports.DetailViewEnum',
			valueField: 'id',
			displayField: 'value',
			allowBlank:false
		},{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('REPORT_FOR'),
			name: 'detailFor',
			itemId: 'detailFor',
			store: 'transport.reports.DetailForEnum',
			valueField: 'id',
			displayField: 'value',
			allowBlank:false
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getTransportTranslation('USER_TYPE'),
			name: 'userType',
			itemId: 'userType',
			store: 'transport.reports.UserTypeEnum',
			valueField: 'id',
			displayField: 'value',
			allowBlank:false
		},{
			xtype: 'multiselectcombofield',
			itemId: 'usersId',
			name: 'usersId',
			queryMode: 'local',
			fieldLabel: getTransportTranslation('USER'),
			store:'transport.vehicle.TransServiceRouteUser',	
			cls:'multiBrandCampusCls',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			maxLength: 25000,
			disabled: true
		}]
	},{
		xtype: 'multiselectcombofield',
		itemId: 'stop',
		name: 'stop',
		fieldLabel: getTransportTranslation('STOP_LOCATIONS'),
		store:'transport.reports.StopsName',
		cls:'multiBrandCampusCls',
		valueField: 'id',
		displayField: 'value',
		allowBlank: true,
		width: 460
	},{
		xtype: 'multiselectcombofield',
		itemId: 'route',
		name: 'route',
		fieldLabel: getTransportTranslation('ROUTES'),
		store:'transport.route.RouteName',	    
		cls:'multiBrandCampusCls',
		valueField: 'id',
		displayField: 'value',
		allowBlank: true,
		hidden:true,
		width: 460
	},{
		xtype: 'multiselectcombofield',
		itemId: 'vehicle',
		name: 'vehicle',
		fieldLabel: getTransportTranslation('VEHICLES'),
		store:'transport.vehicle.VehicleNo',
		cls:'multiBrandCampusCls',
		valueField: 'id',
		displayField: 'value',
		hidden:true,
		allowBlank: true,
		width: 460
	},{
		xtype: 'multiselectcombofield',
		itemId: 'serviceRoute',
		name: 'serviceRoute',
		fieldLabel: getTransportTranslation('SERVICE_ROUTES'),
		store:'transport.serviceRoute.ServiceRouteName',	 
		cls:'multiBrandCampusCls',
		valueField: 'id',
		displayField: 'value',
		hidden:true,
		allowBlank: true,
		width: 460
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		width:'100%',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'datefield',
			name: 'dateFrom',
			itemId:'dateFrom',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype: 'daterange',
			endDateField: 'dateTill',
			editable:false,
			fieldLabel:getTransportTranslation('DATE_FROM')
		},{
			xtype: 'datefield',
			name: 'dateTill',
			itemId:'dateTill',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype: 'daterange',
			startDateField: 'dateFrom',
			editable:false,
			fieldLabel:getTransportTranslation('DATE_TILL')
		}]
	},{
		xtype: 'panel',
		width: '100%',
		style:{marginLeft:'-12px',marginBottom:'-5px'},
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SEARCH'),
			formBind: true,
			itemId: 'SearchBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getTransportTranslation('RESET'),
			itemId: 'cancelBtn',	
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});
