/**
 * @author Rajkumar.Patidar 
 */
Ext.define('Academia.view.transport.serviceRoute.ServiceRoutesForVehicleGridWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.serviceroutesforvehiclegridwindow',
	modal : true,
	resizable:true,
	autoScroll: true,
	height: '40%',
	width: '70%',
	title:getTransportTranslation('VEHICLE_DETAILS'),
	items: [{
		xtype: 'grid',
		store : 'transport.serviceRoute.ServiceRouteForVehicle',
		frame: false,
		border:true,
		autoScroll: false,
		viewConfig : {
			stripeRows : CONSTANTS.STRIPEROWS
		},
		dockedItems : [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [{
				xtype: 'custompagingtoolbar',
				plugins:['pagesize'],
				store : 'transport.serviceRoute.ServiceRouteForVehicle',
				emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
			}]
		}],
		columns: [{
			header : getTransportTranslation('VEHICLE_CODE'),
			dataIndex : 'vehicle',
			flex : 1,
			renderer: function(value) {
				if(!isNullOrEmpty(value)) {
						return value.vehicleCode;
				}
			}
		},{
			header : getTransportTranslation('VEHICLE_NO'),
			dataIndex : 'vehicle',
			flex : 1,
			renderer: function(value) {
				if(!isNullOrEmpty(value)) {
						return value.vehicleNumber;
				}
			}
		},{
			header : getTransportTranslation('VEHICLE_SUB_TYPE'),
			dataIndex : 'vehicle',
			flex : 1,
			renderer: function(value) {
				if(!isNullOrEmpty(value)) {
						return value.vehicleSubTypeName;
				}
			}
		}] 	
	}]
});
