/**
 *  @author Sohan Chouhan

 */

Ext.define('Academia.view.transport.vehicle.FitnessCertificateGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.fitnesscertificategrid',
	store : 'transport.vehicle.FitnessCertificateGridDataStore',
	title: getTransportTranslation('VEHICEL_FITNESS_CERTIFICATE_DETAIL'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'transport.vehicle.FitnessCertificateGridDataStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getTransportTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getTransportTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getTransportTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getTransportTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header : getTransportTranslation('CERTIFIED_BY'),
		dataIndex : 'certifiedBy',
		flex:1
	},{
		header : getTransportTranslation('ISSUE_DATE'),
		dataIndex : 'issueDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('EXPIRATION_DATE'),
		dataIndex : 'expiryDate',
		flex:1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)) {
				return dateRender(date);
			}
		}
	},{
		header : getTransportTranslation('VEHICLE_FITNESS_CERTIFICATE_DOCUMENT'),
		dataIndex : 'fitnessDocumentId',
		flex:1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
					return '<a href="#">' + "1" + '</a>';
			}                        
		}
	}]
});